/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ServiceLimit {
    FILE_SYSTEM_COUNT("FILE_SYSTEM_COUNT"),
    TOTAL_THROUGHPUT_CAPACITY("TOTAL_THROUGHPUT_CAPACITY"),
    TOTAL_STORAGE("TOTAL_STORAGE"),
    TOTAL_USER_INITIATED_BACKUPS("TOTAL_USER_INITIATED_BACKUPS"),
    TOTAL_USER_TAGS("TOTAL_USER_TAGS"),
    TOTAL_IN_PROGRESS_COPY_BACKUPS("TOTAL_IN_PROGRESS_COPY_BACKUPS"),
    STORAGE_VIRTUAL_MACHINES_PER_FILE_SYSTEM("STORAGE_VIRTUAL_MACHINES_PER_FILE_SYSTEM"),
    VOLUMES_PER_FILE_SYSTEM("VOLUMES_PER_FILE_SYSTEM"),
    TOTAL_SSD_IOPS("TOTAL_SSD_IOPS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ServiceLimit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceLimit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ServiceLimit.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceLimit> knownValues() {
        return Stream.of(ServiceLimit.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

