/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.CompletionReport;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskPathsCopier;
import software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataRepositoryTaskRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, CreateDataRepositoryTaskRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateDataRepositoryTaskRequest.getter(CreateDataRepositoryTaskRequest::typeAsString)).setter(CreateDataRepositoryTaskRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Paths").getter(CreateDataRepositoryTaskRequest.getter(CreateDataRepositoryTaskRequest::paths)).setter(CreateDataRepositoryTaskRequest.setter(Builder::paths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Paths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(CreateDataRepositoryTaskRequest.getter(CreateDataRepositoryTaskRequest::fileSystemId)).setter(CreateDataRepositoryTaskRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<CompletionReport> REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Report").getter(CreateDataRepositoryTaskRequest.getter(CreateDataRepositoryTaskRequest::report)).setter(CreateDataRepositoryTaskRequest.setter(Builder::report)).constructor(CompletionReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Report").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateDataRepositoryTaskRequest.getter(CreateDataRepositoryTaskRequest::clientRequestToken)).setter(CreateDataRepositoryTaskRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDataRepositoryTaskRequest.getter(CreateDataRepositoryTaskRequest::tags)).setter(CreateDataRepositoryTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PATHS_FIELD, FILE_SYSTEM_ID_FIELD, REPORT_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private final String type;
    private final List<String> paths;
    private final String fileSystemId;
    private final CompletionReport report;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateDataRepositoryTaskRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.paths = builder.paths;
        this.fileSystemId = builder.fileSystemId;
        this.report = builder.report;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final DataRepositoryTaskType type() {
        return DataRepositoryTaskType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasPaths() {
        return this.paths != null && !(this.paths instanceof SdkAutoConstructList);
    }

    public final List<String> paths() {
        return this.paths;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final CompletionReport report() {
        return this.report;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPaths() ? this.paths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.report());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataRepositoryTaskRequest)) {
            return false;
        }
        CreateDataRepositoryTaskRequest other = (CreateDataRepositoryTaskRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasPaths() == other.hasPaths() && Objects.equals(this.paths(), other.paths()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.report(), other.report()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataRepositoryTaskRequest").add("Type", (Object)this.typeAsString()).add("Paths", this.hasPaths() ? this.paths() : null).add("FileSystemId", (Object)this.fileSystemId()).add("Report", (Object)this.report()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Paths": {
                return Optional.ofNullable(clazz.cast(this.paths()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Report": {
                return Optional.ofNullable(clazz.cast(this.report()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataRepositoryTaskRequest, T> g) {
        return obj -> g.apply((CreateDataRepositoryTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String type;
        private List<String> paths = DefaultSdkAutoConstructList.getInstance();
        private String fileSystemId;
        private CompletionReport report;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataRepositoryTaskRequest model) {
            super(model);
            this.type(model.type);
            this.paths(model.paths);
            this.fileSystemId(model.fileSystemId);
            this.report(model.report);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(DataRepositoryTaskType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getPaths() {
            if (this.paths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.paths;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = DataRepositoryTaskPathsCopier.copy(paths);
        }

        @Override
        @Transient
        public final Builder paths(Collection<String> paths) {
            this.paths = DataRepositoryTaskPathsCopier.copy(paths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder paths(String ... paths) {
            this.paths(Arrays.asList(paths));
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final CompletionReport.Builder getReport() {
            return this.report != null ? this.report.toBuilder() : null;
        }

        public final void setReport(CompletionReport.BuilderImpl report) {
            this.report = report != null ? report.build() : null;
        }

        @Override
        @Transient
        public final Builder report(CompletionReport report) {
            this.report = report;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataRepositoryTaskRequest build() {
            return new CreateDataRepositoryTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataRepositoryTaskRequest> {
        public Builder type(String var1);

        public Builder type(DataRepositoryTaskType var1);

        public Builder paths(Collection<String> var1);

        public Builder paths(String ... var1);

        public Builder fileSystemId(String var1);

        public Builder report(CompletionReport var1);

        default public Builder report(Consumer<CompletionReport.Builder> report) {
            return this.report((CompletionReport)((CompletionReport.Builder)CompletionReport.builder().applyMutation(report)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

