/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration;
import software.amazon.awssdk.services.fsx.model.CreateOpenZFSVolumeConfiguration;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.services.fsx.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVolumeRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, CreateVolumeRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateVolumeRequest.getter(CreateVolumeRequest::clientRequestToken)).setter(CreateVolumeRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(CreateVolumeRequest.getter(CreateVolumeRequest::volumeTypeAsString)).setter(CreateVolumeRequest.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateVolumeRequest.getter(CreateVolumeRequest::name)).setter(CreateVolumeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<CreateOntapVolumeConfiguration> ONTAP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OntapConfiguration").getter(CreateVolumeRequest.getter(CreateVolumeRequest::ontapConfiguration)).setter(CreateVolumeRequest.setter(Builder::ontapConfiguration)).constructor(CreateOntapVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateVolumeRequest.getter(CreateVolumeRequest::tags)).setter(CreateVolumeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CreateOpenZFSVolumeConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration").getter(CreateVolumeRequest.getter(CreateVolumeRequest::openZFSConfiguration)).setter(CreateVolumeRequest.setter(Builder::openZFSConfiguration)).constructor(CreateOpenZFSVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, VOLUME_TYPE_FIELD, NAME_FIELD, ONTAP_CONFIGURATION_FIELD, TAGS_FIELD, OPEN_ZFS_CONFIGURATION_FIELD));
    private final String clientRequestToken;
    private final String volumeType;
    private final String name;
    private final CreateOntapVolumeConfiguration ontapConfiguration;
    private final List<Tag> tags;
    private final CreateOpenZFSVolumeConfiguration openZFSConfiguration;

    private CreateVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.volumeType = builder.volumeType;
        this.name = builder.name;
        this.ontapConfiguration = builder.ontapConfiguration;
        this.tags = builder.tags;
        this.openZFSConfiguration = builder.openZFSConfiguration;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final String name() {
        return this.name;
    }

    public final CreateOntapVolumeConfiguration ontapConfiguration() {
        return this.ontapConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final CreateOpenZFSVolumeConfiguration openZFSConfiguration() {
        return this.openZFSConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ontapConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.openZFSConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeRequest)) {
            return false;
        }
        CreateVolumeRequest other = (CreateVolumeRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ontapConfiguration(), other.ontapConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.openZFSConfiguration(), other.openZFSConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVolumeRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("VolumeType", (Object)this.volumeTypeAsString()).add("Name", (Object)this.name()).add("OntapConfiguration", (Object)this.ontapConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("OpenZFSConfiguration", (Object)this.openZFSConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OntapConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ontapConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "OpenZFSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.openZFSConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVolumeRequest, T> g) {
        return obj -> g.apply((CreateVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String volumeType;
        private String name;
        private CreateOntapVolumeConfiguration ontapConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private CreateOpenZFSVolumeConfiguration openZFSConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumeRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.volumeType(model.volumeType);
            this.name(model.name);
            this.ontapConfiguration(model.ontapConfiguration);
            this.tags(model.tags);
            this.openZFSConfiguration(model.openZFSConfiguration);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CreateOntapVolumeConfiguration.Builder getOntapConfiguration() {
            return this.ontapConfiguration != null ? this.ontapConfiguration.toBuilder() : null;
        }

        public final void setOntapConfiguration(CreateOntapVolumeConfiguration.BuilderImpl ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration != null ? ontapConfiguration.build() : null;
        }

        @Override
        public final Builder ontapConfiguration(CreateOntapVolumeConfiguration ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CreateOpenZFSVolumeConfiguration.Builder getOpenZFSConfiguration() {
            return this.openZFSConfiguration != null ? this.openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(CreateOpenZFSVolumeConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(CreateOpenZFSVolumeConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVolumeRequest build() {
            return new CreateVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVolumeRequest> {
        public Builder clientRequestToken(String var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder name(String var1);

        public Builder ontapConfiguration(CreateOntapVolumeConfiguration var1);

        default public Builder ontapConfiguration(Consumer<CreateOntapVolumeConfiguration.Builder> ontapConfiguration) {
            return this.ontapConfiguration((CreateOntapVolumeConfiguration)((CreateOntapVolumeConfiguration.Builder)CreateOntapVolumeConfiguration.builder().applyMutation(ontapConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder openZFSConfiguration(CreateOpenZFSVolumeConfiguration var1);

        default public Builder openZFSConfiguration(Consumer<CreateOpenZFSVolumeConfiguration.Builder> openZFSConfiguration) {
            return this.openZFSConfiguration((CreateOpenZFSVolumeConfiguration)((CreateOpenZFSVolumeConfiguration.Builder)CreateOpenZFSVolumeConfiguration.builder().applyMutation(openZFSConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

