/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LustreLogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LustreLogConfiguration> {
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Level").getter(LustreLogConfiguration.getter(LustreLogConfiguration::levelAsString)).setter(LustreLogConfiguration.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(LustreLogConfiguration.getter(LustreLogConfiguration::destination)).setter(LustreLogConfiguration.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL_FIELD, DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String level;
    private final String destination;

    private LustreLogConfiguration(BuilderImpl builder) {
        this.level = builder.level;
        this.destination = builder.destination;
    }

    public final LustreAccessAuditLogLevel level() {
        return LustreAccessAuditLogLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final String destination() {
        return this.destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LustreLogConfiguration)) {
            return false;
        }
        LustreLogConfiguration other = (LustreLogConfiguration)obj;
        return Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.destination(), other.destination());
    }

    public final String toString() {
        return ToString.builder((String)"LustreLogConfiguration").add("Level", (Object)this.levelAsString()).add("Destination", (Object)this.destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LustreLogConfiguration, T> g) {
        return obj -> g.apply((LustreLogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String level;
        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(LustreLogConfiguration model) {
            this.level(model.level);
            this.destination(model.destination);
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        @Transient
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        @Transient
        public final Builder level(LustreAccessAuditLogLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        @Transient
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public LustreLogConfiguration build() {
            return new LustreLogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LustreLogConfiguration> {
        public Builder level(String var1);

        public Builder level(LustreAccessAuditLogLevel var1);

        public Builder destination(String var1);
    }
}

