/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.UpdateSvmActiveDirectoryConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStorageVirtualMachineRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, UpdateStorageVirtualMachineRequest> {
    private static final SdkField<UpdateSvmActiveDirectoryConfiguration> ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActiveDirectoryConfiguration").getter(UpdateStorageVirtualMachineRequest.getter(UpdateStorageVirtualMachineRequest::activeDirectoryConfiguration)).setter(UpdateStorageVirtualMachineRequest.setter(Builder::activeDirectoryConfiguration)).constructor(UpdateSvmActiveDirectoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(UpdateStorageVirtualMachineRequest.getter(UpdateStorageVirtualMachineRequest::clientRequestToken)).setter(UpdateStorageVirtualMachineRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageVirtualMachineId").getter(UpdateStorageVirtualMachineRequest.getter(UpdateStorageVirtualMachineRequest::storageVirtualMachineId)).setter(UpdateStorageVirtualMachineRequest.setter(Builder::storageVirtualMachineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build()}).build();
    private static final SdkField<String> SVM_ADMIN_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SvmAdminPassword").getter(UpdateStorageVirtualMachineRequest.getter(UpdateStorageVirtualMachineRequest::svmAdminPassword)).setter(UpdateStorageVirtualMachineRequest.setter(Builder::svmAdminPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SvmAdminPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_CONFIGURATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, STORAGE_VIRTUAL_MACHINE_ID_FIELD, SVM_ADMIN_PASSWORD_FIELD));
    private final UpdateSvmActiveDirectoryConfiguration activeDirectoryConfiguration;
    private final String clientRequestToken;
    private final String storageVirtualMachineId;
    private final String svmAdminPassword;

    private UpdateStorageVirtualMachineRequest(BuilderImpl builder) {
        super(builder);
        this.activeDirectoryConfiguration = builder.activeDirectoryConfiguration;
        this.clientRequestToken = builder.clientRequestToken;
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.svmAdminPassword = builder.svmAdminPassword;
    }

    public final UpdateSvmActiveDirectoryConfiguration activeDirectoryConfiguration() {
        return this.activeDirectoryConfiguration;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String storageVirtualMachineId() {
        return this.storageVirtualMachineId;
    }

    public final String svmAdminPassword() {
        return this.svmAdminPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.svmAdminPassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStorageVirtualMachineRequest)) {
            return false;
        }
        UpdateStorageVirtualMachineRequest other = (UpdateStorageVirtualMachineRequest)((Object)obj);
        return Objects.equals(this.activeDirectoryConfiguration(), other.activeDirectoryConfiguration()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.storageVirtualMachineId(), other.storageVirtualMachineId()) && Objects.equals(this.svmAdminPassword(), other.svmAdminPassword());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStorageVirtualMachineRequest").add("ActiveDirectoryConfiguration", (Object)this.activeDirectoryConfiguration()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("StorageVirtualMachineId", (Object)this.storageVirtualMachineId()).add("SvmAdminPassword", (Object)(this.svmAdminPassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveDirectoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryConfiguration()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "StorageVirtualMachineId": {
                return Optional.ofNullable(clazz.cast(this.storageVirtualMachineId()));
            }
            case "SvmAdminPassword": {
                return Optional.ofNullable(clazz.cast(this.svmAdminPassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStorageVirtualMachineRequest, T> g) {
        return obj -> g.apply((UpdateStorageVirtualMachineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private UpdateSvmActiveDirectoryConfiguration activeDirectoryConfiguration;
        private String clientRequestToken;
        private String storageVirtualMachineId;
        private String svmAdminPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStorageVirtualMachineRequest model) {
            super(model);
            this.activeDirectoryConfiguration(model.activeDirectoryConfiguration);
            this.clientRequestToken(model.clientRequestToken);
            this.storageVirtualMachineId(model.storageVirtualMachineId);
            this.svmAdminPassword(model.svmAdminPassword);
        }

        public final UpdateSvmActiveDirectoryConfiguration.Builder getActiveDirectoryConfiguration() {
            return this.activeDirectoryConfiguration != null ? this.activeDirectoryConfiguration.toBuilder() : null;
        }

        public final void setActiveDirectoryConfiguration(UpdateSvmActiveDirectoryConfiguration.BuilderImpl activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration != null ? activeDirectoryConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder activeDirectoryConfiguration(UpdateSvmActiveDirectoryConfiguration activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getStorageVirtualMachineId() {
            return this.storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        @Transient
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final String getSvmAdminPassword() {
            return this.svmAdminPassword;
        }

        public final void setSvmAdminPassword(String svmAdminPassword) {
            this.svmAdminPassword = svmAdminPassword;
        }

        @Override
        @Transient
        public final Builder svmAdminPassword(String svmAdminPassword) {
            this.svmAdminPassword = svmAdminPassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStorageVirtualMachineRequest build() {
            return new UpdateStorageVirtualMachineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStorageVirtualMachineRequest> {
        public Builder activeDirectoryConfiguration(UpdateSvmActiveDirectoryConfiguration var1);

        default public Builder activeDirectoryConfiguration(Consumer<UpdateSvmActiveDirectoryConfiguration.Builder> activeDirectoryConfiguration) {
            return this.activeDirectoryConfiguration((UpdateSvmActiveDirectoryConfiguration)((UpdateSvmActiveDirectoryConfiguration.Builder)UpdateSvmActiveDirectoryConfiguration.builder().applyMutation(activeDirectoryConfiguration)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder storageVirtualMachineId(String var1);

        public Builder svmAdminPassword(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

