/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.AdministrativeAction;
import software.amazon.awssdk.services.fsx.model.AdministrativeActionsCopier;
import software.amazon.awssdk.services.fsx.model.SnapshotLifecycle;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Snapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Snapshot> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(Snapshot.getter(Snapshot::resourceARN)).setter(Snapshot.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(Snapshot.getter(Snapshot::snapshotId)).setter(Snapshot.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Snapshot.getter(Snapshot::name)).setter(Snapshot.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(Snapshot.getter(Snapshot::volumeId)).setter(Snapshot.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Snapshot.getter(Snapshot::creationTime)).setter(Snapshot.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(Snapshot.getter(Snapshot::lifecycleAsString)).setter(Snapshot.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Snapshot.getter(Snapshot::tags)).setter(Snapshot.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AdministrativeAction>> ADMINISTRATIVE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdministrativeActions").getter(Snapshot.getter(Snapshot::administrativeActions)).setter(Snapshot.setter(Builder::administrativeActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdministrativeAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, SNAPSHOT_ID_FIELD, NAME_FIELD, VOLUME_ID_FIELD, CREATION_TIME_FIELD, LIFECYCLE_FIELD, TAGS_FIELD, ADMINISTRATIVE_ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceARN;
    private final String snapshotId;
    private final String name;
    private final String volumeId;
    private final Instant creationTime;
    private final String lifecycle;
    private final List<Tag> tags;
    private final List<AdministrativeAction> administrativeActions;

    private Snapshot(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.snapshotId = builder.snapshotId;
        this.name = builder.name;
        this.volumeId = builder.volumeId;
        this.creationTime = builder.creationTime;
        this.lifecycle = builder.lifecycle;
        this.tags = builder.tags;
        this.administrativeActions = builder.administrativeActions;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String name() {
        return this.name;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final SnapshotLifecycle lifecycle() {
        return SnapshotLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasAdministrativeActions() {
        return this.administrativeActions != null && !(this.administrativeActions instanceof SdkAutoConstructList);
    }

    public final List<AdministrativeAction> administrativeActions() {
        return this.administrativeActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdministrativeActions() ? this.administrativeActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAdministrativeActions() == other.hasAdministrativeActions() && Objects.equals(this.administrativeActions(), other.administrativeActions());
    }

    public final String toString() {
        return ToString.builder((String)"Snapshot").add("ResourceARN", (Object)this.resourceARN()).add("SnapshotId", (Object)this.snapshotId()).add("Name", (Object)this.name()).add("VolumeId", (Object)this.volumeId()).add("CreationTime", (Object)this.creationTime()).add("Lifecycle", (Object)this.lifecycleAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("AdministrativeActions", this.hasAdministrativeActions() ? this.administrativeActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AdministrativeActions": {
                return Optional.ofNullable(clazz.cast(this.administrativeActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceARN;
        private String snapshotId;
        private String name;
        private String volumeId;
        private Instant creationTime;
        private String lifecycle;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<AdministrativeAction> administrativeActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.resourceARN(model.resourceARN);
            this.snapshotId(model.snapshotId);
            this.name(model.name);
            this.volumeId(model.volumeId);
            this.creationTime(model.creationTime);
            this.lifecycle(model.lifecycle);
            this.tags(model.tags);
            this.administrativeActions(model.administrativeActions);
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        @Transient
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        @Transient
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        @Transient
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        @Transient
        public final Builder lifecycle(SnapshotLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AdministrativeAction.Builder> getAdministrativeActions() {
            List<AdministrativeAction.Builder> result = AdministrativeActionsCopier.copyToBuilder(this.administrativeActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdministrativeActions(Collection<AdministrativeAction.BuilderImpl> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copyFromBuilder(administrativeActions);
        }

        @Override
        @Transient
        public final Builder administrativeActions(Collection<AdministrativeAction> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copy(administrativeActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder administrativeActions(AdministrativeAction ... administrativeActions) {
            this.administrativeActions(Arrays.asList(administrativeActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder administrativeActions(Consumer<AdministrativeAction.Builder> ... administrativeActions) {
            this.administrativeActions(Stream.of(administrativeActions).map(c -> (AdministrativeAction)((AdministrativeAction.Builder)AdministrativeAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Snapshot> {
        public Builder resourceARN(String var1);

        public Builder snapshotId(String var1);

        public Builder name(String var1);

        public Builder volumeId(String var1);

        public Builder creationTime(Instant var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(SnapshotLifecycle var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder administrativeActions(Collection<AdministrativeAction> var1);

        public Builder administrativeActions(AdministrativeAction ... var1);

        public Builder administrativeActions(Consumer<AdministrativeAction.Builder> ... var1);
    }
}

