/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation;
import software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperationsCopier;
import software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes;
import software.amazon.awssdk.services.fsx.model.WindowsDeploymentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WindowsFileSystemConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WindowsFileSystemConfiguration> {
    private static final SdkField<String> ACTIVE_DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::activeDirectoryId)).setter(WindowsFileSystemConfiguration.setter(Builder::activeDirectoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryId").build()}).build();
    private static final SdkField<SelfManagedActiveDirectoryAttributes> SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::selfManagedActiveDirectoryConfiguration)).setter(WindowsFileSystemConfiguration.setter(Builder::selfManagedActiveDirectoryConfiguration)).constructor(SelfManagedActiveDirectoryAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedActiveDirectoryConfiguration").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::deploymentTypeAsString)).setter(WindowsFileSystemConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<String> REMOTE_ADMINISTRATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::remoteAdministrationEndpoint)).setter(WindowsFileSystemConfiguration.setter(Builder::remoteAdministrationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteAdministrationEndpoint").build()}).build();
    private static final SdkField<String> PREFERRED_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::preferredSubnetId)).setter(WindowsFileSystemConfiguration.setter(Builder::preferredSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredSubnetId").build()}).build();
    private static final SdkField<String> PREFERRED_FILE_SERVER_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::preferredFileServerIp)).setter(WindowsFileSystemConfiguration.setter(Builder::preferredFileServerIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredFileServerIp").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::throughputCapacity)).setter(WindowsFileSystemConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<List<String>> MAINTENANCE_OPERATIONS_IN_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::maintenanceOperationsInProgressAsStrings)).setter(WindowsFileSystemConfiguration.setter(Builder::maintenanceOperationsInProgressWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOperationsInProgress").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::weeklyMaintenanceStartTime)).setter(WindowsFileSystemConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::dailyAutomaticBackupStartTime)).setter(WindowsFileSystemConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::automaticBackupRetentionDays)).setter(WindowsFileSystemConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::copyTagsToBackups)).setter(WindowsFileSystemConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_ID_FIELD, SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD, DEPLOYMENT_TYPE_FIELD, REMOTE_ADMINISTRATION_ENDPOINT_FIELD, PREFERRED_SUBNET_ID_FIELD, PREFERRED_FILE_SERVER_IP_FIELD, THROUGHPUT_CAPACITY_FIELD, MAINTENANCE_OPERATIONS_IN_PROGRESS_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activeDirectoryId;
    private final SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration;
    private final String deploymentType;
    private final String remoteAdministrationEndpoint;
    private final String preferredSubnetId;
    private final String preferredFileServerIp;
    private final Integer throughputCapacity;
    private final List<String> maintenanceOperationsInProgress;
    private final String weeklyMaintenanceStartTime;
    private final String dailyAutomaticBackupStartTime;
    private final Integer automaticBackupRetentionDays;
    private final Boolean copyTagsToBackups;

    private WindowsFileSystemConfiguration(BuilderImpl builder) {
        this.activeDirectoryId = builder.activeDirectoryId;
        this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
        this.deploymentType = builder.deploymentType;
        this.remoteAdministrationEndpoint = builder.remoteAdministrationEndpoint;
        this.preferredSubnetId = builder.preferredSubnetId;
        this.preferredFileServerIp = builder.preferredFileServerIp;
        this.throughputCapacity = builder.throughputCapacity;
        this.maintenanceOperationsInProgress = builder.maintenanceOperationsInProgress;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
    }

    public String activeDirectoryId() {
        return this.activeDirectoryId;
    }

    public SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration() {
        return this.selfManagedActiveDirectoryConfiguration;
    }

    public WindowsDeploymentType deploymentType() {
        return WindowsDeploymentType.fromValue(this.deploymentType);
    }

    public String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public String remoteAdministrationEndpoint() {
        return this.remoteAdministrationEndpoint;
    }

    public String preferredSubnetId() {
        return this.preferredSubnetId;
    }

    public String preferredFileServerIp() {
        return this.preferredFileServerIp;
    }

    public Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public List<FileSystemMaintenanceOperation> maintenanceOperationsInProgress() {
        return FileSystemMaintenanceOperationsCopier.copyStringToEnum(this.maintenanceOperationsInProgress);
    }

    public boolean hasMaintenanceOperationsInProgress() {
        return this.maintenanceOperationsInProgress != null && !(this.maintenanceOperationsInProgress instanceof SdkAutoConstructList);
    }

    public List<String> maintenanceOperationsInProgressAsStrings() {
        return this.maintenanceOperationsInProgress;
    }

    public String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedActiveDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAdministrationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredFileServerIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceOperationsInProgressAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowsFileSystemConfiguration)) {
            return false;
        }
        WindowsFileSystemConfiguration other = (WindowsFileSystemConfiguration)obj;
        return Objects.equals(this.activeDirectoryId(), other.activeDirectoryId()) && Objects.equals(this.selfManagedActiveDirectoryConfiguration(), other.selfManagedActiveDirectoryConfiguration()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.remoteAdministrationEndpoint(), other.remoteAdministrationEndpoint()) && Objects.equals(this.preferredSubnetId(), other.preferredSubnetId()) && Objects.equals(this.preferredFileServerIp(), other.preferredFileServerIp()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && Objects.equals(this.maintenanceOperationsInProgressAsStrings(), other.maintenanceOperationsInProgressAsStrings()) && Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups());
    }

    public String toString() {
        return ToString.builder((String)"WindowsFileSystemConfiguration").add("ActiveDirectoryId", (Object)this.activeDirectoryId()).add("SelfManagedActiveDirectoryConfiguration", (Object)this.selfManagedActiveDirectoryConfiguration()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("RemoteAdministrationEndpoint", (Object)this.remoteAdministrationEndpoint()).add("PreferredSubnetId", (Object)this.preferredSubnetId()).add("PreferredFileServerIp", (Object)this.preferredFileServerIp()).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("MaintenanceOperationsInProgress", this.maintenanceOperationsInProgressAsStrings()).add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveDirectoryId": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryId()));
            }
            case "SelfManagedActiveDirectoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.selfManagedActiveDirectoryConfiguration()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "RemoteAdministrationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.remoteAdministrationEndpoint()));
            }
            case "PreferredSubnetId": {
                return Optional.ofNullable(clazz.cast(this.preferredSubnetId()));
            }
            case "PreferredFileServerIp": {
                return Optional.ofNullable(clazz.cast(this.preferredFileServerIp()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "MaintenanceOperationsInProgress": {
                return Optional.ofNullable(clazz.cast(this.maintenanceOperationsInProgressAsStrings()));
            }
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WindowsFileSystemConfiguration, T> g) {
        return obj -> g.apply((WindowsFileSystemConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activeDirectoryId;
        private SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration;
        private String deploymentType;
        private String remoteAdministrationEndpoint;
        private String preferredSubnetId;
        private String preferredFileServerIp;
        private Integer throughputCapacity;
        private List<String> maintenanceOperationsInProgress = DefaultSdkAutoConstructList.getInstance();
        private String weeklyMaintenanceStartTime;
        private String dailyAutomaticBackupStartTime;
        private Integer automaticBackupRetentionDays;
        private Boolean copyTagsToBackups;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowsFileSystemConfiguration model) {
            this.activeDirectoryId(model.activeDirectoryId);
            this.selfManagedActiveDirectoryConfiguration(model.selfManagedActiveDirectoryConfiguration);
            this.deploymentType(model.deploymentType);
            this.remoteAdministrationEndpoint(model.remoteAdministrationEndpoint);
            this.preferredSubnetId(model.preferredSubnetId);
            this.preferredFileServerIp(model.preferredFileServerIp);
            this.throughputCapacity(model.throughputCapacity);
            this.maintenanceOperationsInProgressWithStrings(model.maintenanceOperationsInProgress);
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.copyTagsToBackups(model.copyTagsToBackups);
        }

        public final String getActiveDirectoryId() {
            return this.activeDirectoryId;
        }

        @Override
        public final Builder activeDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
            return this;
        }

        public final void setActiveDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
        }

        public final SelfManagedActiveDirectoryAttributes.Builder getSelfManagedActiveDirectoryConfiguration() {
            return this.selfManagedActiveDirectoryConfiguration != null ? this.selfManagedActiveDirectoryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
            return this;
        }

        public final void setSelfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes.BuilderImpl selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration.build() : null;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(WindowsDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final String getRemoteAdministrationEndpoint() {
            return this.remoteAdministrationEndpoint;
        }

        @Override
        public final Builder remoteAdministrationEndpoint(String remoteAdministrationEndpoint) {
            this.remoteAdministrationEndpoint = remoteAdministrationEndpoint;
            return this;
        }

        public final void setRemoteAdministrationEndpoint(String remoteAdministrationEndpoint) {
            this.remoteAdministrationEndpoint = remoteAdministrationEndpoint;
        }

        public final String getPreferredSubnetId() {
            return this.preferredSubnetId;
        }

        @Override
        public final Builder preferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
            return this;
        }

        public final void setPreferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
        }

        public final String getPreferredFileServerIp() {
            return this.preferredFileServerIp;
        }

        @Override
        public final Builder preferredFileServerIp(String preferredFileServerIp) {
            this.preferredFileServerIp = preferredFileServerIp;
            return this;
        }

        public final void setPreferredFileServerIp(String preferredFileServerIp) {
            this.preferredFileServerIp = preferredFileServerIp;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        public final Collection<String> getMaintenanceOperationsInProgress() {
            return this.maintenanceOperationsInProgress;
        }

        @Override
        public final Builder maintenanceOperationsInProgressWithStrings(Collection<String> maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgress = FileSystemMaintenanceOperationsCopier.copy(maintenanceOperationsInProgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceOperationsInProgressWithStrings(String ... maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgressWithStrings(Arrays.asList(maintenanceOperationsInProgress));
            return this;
        }

        @Override
        public final Builder maintenanceOperationsInProgress(Collection<FileSystemMaintenanceOperation> maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgress = FileSystemMaintenanceOperationsCopier.copyEnumToString(maintenanceOperationsInProgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceOperationsInProgress(FileSystemMaintenanceOperation ... maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgress(Arrays.asList(maintenanceOperationsInProgress));
            return this;
        }

        public final void setMaintenanceOperationsInProgress(Collection<String> maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgress = FileSystemMaintenanceOperationsCopier.copy(maintenanceOperationsInProgress);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        public WindowsFileSystemConfiguration build() {
            return new WindowsFileSystemConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WindowsFileSystemConfiguration> {
        public Builder activeDirectoryId(String var1);

        public Builder selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes var1);

        default public Builder selfManagedActiveDirectoryConfiguration(Consumer<SelfManagedActiveDirectoryAttributes.Builder> selfManagedActiveDirectoryConfiguration) {
            return this.selfManagedActiveDirectoryConfiguration((SelfManagedActiveDirectoryAttributes)((SelfManagedActiveDirectoryAttributes.Builder)SelfManagedActiveDirectoryAttributes.builder().applyMutation(selfManagedActiveDirectoryConfiguration)).build());
        }

        public Builder deploymentType(String var1);

        public Builder deploymentType(WindowsDeploymentType var1);

        public Builder remoteAdministrationEndpoint(String var1);

        public Builder preferredSubnetId(String var1);

        public Builder preferredFileServerIp(String var1);

        public Builder throughputCapacity(Integer var1);

        public Builder maintenanceOperationsInProgressWithStrings(Collection<String> var1);

        public Builder maintenanceOperationsInProgressWithStrings(String ... var1);

        public Builder maintenanceOperationsInProgress(Collection<FileSystemMaintenanceOperation> var1);

        public Builder maintenanceOperationsInProgress(FileSystemMaintenanceOperation ... var1);

        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder copyTagsToBackups(Boolean var1);
    }
}

