/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeBackupsResponse;

public class DescribeBackupsIterable
implements SdkIterable<DescribeBackupsResponse> {
    private final FSxClient client;
    private final DescribeBackupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBackupsIterable(FSxClient client, DescribeBackupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeBackupsResponseFetcher();
    }

    public Iterator<DescribeBackupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeBackupsIterable resume(DescribeBackupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeBackupsIterable(this.client, (DescribeBackupsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeBackupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeBackupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeBackupsResponseFetcher
    implements SyncPageFetcher<DescribeBackupsResponse> {
        private DescribeBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBackupsResponse nextPage(DescribeBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBackupsIterable.this.client.describeBackups(DescribeBackupsIterable.this.firstRequest);
            }
            return DescribeBackupsIterable.this.client.describeBackups((DescribeBackupsRequest)((Object)DescribeBackupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

