/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.freetier.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountPlanStateResponse extends FreeTierResponse implements
        ToCopyableBuilder<GetAccountPlanStateResponse.Builder, GetAccountPlanStateResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(GetAccountPlanStateResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ACCOUNT_PLAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountPlanType").getter(getter(GetAccountPlanStateResponse::accountPlanTypeAsString))
            .setter(setter(Builder::accountPlanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPlanType").build()).build();

    private static final SdkField<String> ACCOUNT_PLAN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountPlanStatus").getter(getter(GetAccountPlanStateResponse::accountPlanStatusAsString))
            .setter(setter(Builder::accountPlanStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPlanStatus").build()).build();

    private static final SdkField<MonetaryAmount> ACCOUNT_PLAN_REMAINING_CREDITS_FIELD = SdkField
            .<MonetaryAmount> builder(MarshallingType.SDK_POJO)
            .memberName("accountPlanRemainingCredits")
            .getter(getter(GetAccountPlanStateResponse::accountPlanRemainingCredits))
            .setter(setter(Builder::accountPlanRemainingCredits))
            .constructor(MonetaryAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPlanRemainingCredits")
                    .build()).build();

    private static final SdkField<Instant> ACCOUNT_PLAN_EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("accountPlanExpirationDate")
            .getter(getter(GetAccountPlanStateResponse::accountPlanExpirationDate))
            .setter(setter(Builder::accountPlanExpirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPlanExpirationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ACCOUNT_PLAN_TYPE_FIELD, ACCOUNT_PLAN_STATUS_FIELD, ACCOUNT_PLAN_REMAINING_CREDITS_FIELD,
            ACCOUNT_PLAN_EXPIRATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String accountPlanType;

    private final String accountPlanStatus;

    private final MonetaryAmount accountPlanRemainingCredits;

    private final Instant accountPlanExpirationDate;

    private GetAccountPlanStateResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.accountPlanType = builder.accountPlanType;
        this.accountPlanStatus = builder.accountPlanStatus;
        this.accountPlanRemainingCredits = builder.accountPlanRemainingCredits;
        this.accountPlanExpirationDate = builder.accountPlanExpirationDate;
    }

    /**
     * <p>
     * A unique identifier that identifies the account.
     * </p>
     * 
     * @return A unique identifier that identifies the account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The plan type for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountPlanType}
     * will return {@link AccountPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountPlanTypeAsString}.
     * </p>
     * 
     * @return The plan type for the account.
     * @see AccountPlanType
     */
    public final AccountPlanType accountPlanType() {
        return AccountPlanType.fromValue(accountPlanType);
    }

    /**
     * <p>
     * The plan type for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountPlanType}
     * will return {@link AccountPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountPlanTypeAsString}.
     * </p>
     * 
     * @return The plan type for the account.
     * @see AccountPlanType
     */
    public final String accountPlanTypeAsString() {
        return accountPlanType;
    }

    /**
     * <p>
     * The current status for the account plan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountPlanStatus}
     * will return {@link AccountPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountPlanStatusAsString}.
     * </p>
     * 
     * @return The current status for the account plan.
     * @see AccountPlanStatus
     */
    public final AccountPlanStatus accountPlanStatus() {
        return AccountPlanStatus.fromValue(accountPlanStatus);
    }

    /**
     * <p>
     * The current status for the account plan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountPlanStatus}
     * will return {@link AccountPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountPlanStatusAsString}.
     * </p>
     * 
     * @return The current status for the account plan.
     * @see AccountPlanStatus
     */
    public final String accountPlanStatusAsString() {
        return accountPlanStatus;
    }

    /**
     * <p>
     * The amount of credits remaining for the account.
     * </p>
     * 
     * @return The amount of credits remaining for the account.
     */
    public final MonetaryAmount accountPlanRemainingCredits() {
        return accountPlanRemainingCredits;
    }

    /**
     * <p>
     * The timestamp for when the current account plan expires.
     * </p>
     * 
     * @return The timestamp for when the current account plan expires.
     */
    public final Instant accountPlanExpirationDate() {
        return accountPlanExpirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accountPlanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountPlanStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountPlanRemainingCredits());
        hashCode = 31 * hashCode + Objects.hashCode(accountPlanExpirationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountPlanStateResponse)) {
            return false;
        }
        GetAccountPlanStateResponse other = (GetAccountPlanStateResponse) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(accountPlanTypeAsString(), other.accountPlanTypeAsString())
                && Objects.equals(accountPlanStatusAsString(), other.accountPlanStatusAsString())
                && Objects.equals(accountPlanRemainingCredits(), other.accountPlanRemainingCredits())
                && Objects.equals(accountPlanExpirationDate(), other.accountPlanExpirationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountPlanStateResponse").add("AccountId", accountId())
                .add("AccountPlanType", accountPlanTypeAsString()).add("AccountPlanStatus", accountPlanStatusAsString())
                .add("AccountPlanRemainingCredits", accountPlanRemainingCredits())
                .add("AccountPlanExpirationDate", accountPlanExpirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "accountPlanType":
            return Optional.ofNullable(clazz.cast(accountPlanTypeAsString()));
        case "accountPlanStatus":
            return Optional.ofNullable(clazz.cast(accountPlanStatusAsString()));
        case "accountPlanRemainingCredits":
            return Optional.ofNullable(clazz.cast(accountPlanRemainingCredits()));
        case "accountPlanExpirationDate":
            return Optional.ofNullable(clazz.cast(accountPlanExpirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("accountPlanType", ACCOUNT_PLAN_TYPE_FIELD);
        map.put("accountPlanStatus", ACCOUNT_PLAN_STATUS_FIELD);
        map.put("accountPlanRemainingCredits", ACCOUNT_PLAN_REMAINING_CREDITS_FIELD);
        map.put("accountPlanExpirationDate", ACCOUNT_PLAN_EXPIRATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountPlanStateResponse, T> g) {
        return obj -> g.apply((GetAccountPlanStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FreeTierResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountPlanStateResponse> {
        /**
         * <p>
         * A unique identifier that identifies the account.
         * </p>
         * 
         * @param accountId
         *        A unique identifier that identifies the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The plan type for the account.
         * </p>
         * 
         * @param accountPlanType
         *        The plan type for the account.
         * @see AccountPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountPlanType
         */
        Builder accountPlanType(String accountPlanType);

        /**
         * <p>
         * The plan type for the account.
         * </p>
         * 
         * @param accountPlanType
         *        The plan type for the account.
         * @see AccountPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountPlanType
         */
        Builder accountPlanType(AccountPlanType accountPlanType);

        /**
         * <p>
         * The current status for the account plan.
         * </p>
         * 
         * @param accountPlanStatus
         *        The current status for the account plan.
         * @see AccountPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountPlanStatus
         */
        Builder accountPlanStatus(String accountPlanStatus);

        /**
         * <p>
         * The current status for the account plan.
         * </p>
         * 
         * @param accountPlanStatus
         *        The current status for the account plan.
         * @see AccountPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountPlanStatus
         */
        Builder accountPlanStatus(AccountPlanStatus accountPlanStatus);

        /**
         * <p>
         * The amount of credits remaining for the account.
         * </p>
         * 
         * @param accountPlanRemainingCredits
         *        The amount of credits remaining for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPlanRemainingCredits(MonetaryAmount accountPlanRemainingCredits);

        /**
         * <p>
         * The amount of credits remaining for the account.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryAmount.Builder} avoiding the need
         * to create one manually via {@link MonetaryAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryAmount.Builder#build()} is called immediately and its
         * result is passed to {@link #accountPlanRemainingCredits(MonetaryAmount)}.
         * 
         * @param accountPlanRemainingCredits
         *        a consumer that will call methods on {@link MonetaryAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountPlanRemainingCredits(MonetaryAmount)
         */
        default Builder accountPlanRemainingCredits(Consumer<MonetaryAmount.Builder> accountPlanRemainingCredits) {
            return accountPlanRemainingCredits(MonetaryAmount.builder().applyMutation(accountPlanRemainingCredits).build());
        }

        /**
         * <p>
         * The timestamp for when the current account plan expires.
         * </p>
         * 
         * @param accountPlanExpirationDate
         *        The timestamp for when the current account plan expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPlanExpirationDate(Instant accountPlanExpirationDate);
    }

    static final class BuilderImpl extends FreeTierResponse.BuilderImpl implements Builder {
        private String accountId;

        private String accountPlanType;

        private String accountPlanStatus;

        private MonetaryAmount accountPlanRemainingCredits;

        private Instant accountPlanExpirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountPlanStateResponse model) {
            super(model);
            accountId(model.accountId);
            accountPlanType(model.accountPlanType);
            accountPlanStatus(model.accountPlanStatus);
            accountPlanRemainingCredits(model.accountPlanRemainingCredits);
            accountPlanExpirationDate(model.accountPlanExpirationDate);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccountPlanType() {
            return accountPlanType;
        }

        public final void setAccountPlanType(String accountPlanType) {
            this.accountPlanType = accountPlanType;
        }

        @Override
        public final Builder accountPlanType(String accountPlanType) {
            this.accountPlanType = accountPlanType;
            return this;
        }

        @Override
        public final Builder accountPlanType(AccountPlanType accountPlanType) {
            this.accountPlanType(accountPlanType == null ? null : accountPlanType.toString());
            return this;
        }

        public final String getAccountPlanStatus() {
            return accountPlanStatus;
        }

        public final void setAccountPlanStatus(String accountPlanStatus) {
            this.accountPlanStatus = accountPlanStatus;
        }

        @Override
        public final Builder accountPlanStatus(String accountPlanStatus) {
            this.accountPlanStatus = accountPlanStatus;
            return this;
        }

        @Override
        public final Builder accountPlanStatus(AccountPlanStatus accountPlanStatus) {
            this.accountPlanStatus(accountPlanStatus == null ? null : accountPlanStatus.toString());
            return this;
        }

        public final MonetaryAmount.Builder getAccountPlanRemainingCredits() {
            return accountPlanRemainingCredits != null ? accountPlanRemainingCredits.toBuilder() : null;
        }

        public final void setAccountPlanRemainingCredits(MonetaryAmount.BuilderImpl accountPlanRemainingCredits) {
            this.accountPlanRemainingCredits = accountPlanRemainingCredits != null ? accountPlanRemainingCredits.build() : null;
        }

        @Override
        public final Builder accountPlanRemainingCredits(MonetaryAmount accountPlanRemainingCredits) {
            this.accountPlanRemainingCredits = accountPlanRemainingCredits;
            return this;
        }

        public final Instant getAccountPlanExpirationDate() {
            return accountPlanExpirationDate;
        }

        public final void setAccountPlanExpirationDate(Instant accountPlanExpirationDate) {
            this.accountPlanExpirationDate = accountPlanExpirationDate;
        }

        @Override
        public final Builder accountPlanExpirationDate(Instant accountPlanExpirationDate) {
            this.accountPlanExpirationDate = accountPlanExpirationDate;
            return this;
        }

        @Override
        public GetAccountPlanStateResponse build() {
            return new GetAccountPlanStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
