/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.freetier.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountActivityResponse extends FreeTierResponse implements
        ToCopyableBuilder<GetAccountActivityResponse.Builder, GetAccountActivityResponse> {
    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activityId").getter(getter(GetAccountActivityResponse::activityId)).setter(setter(Builder::activityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(GetAccountActivityResponse::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetAccountActivityResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetAccountActivityResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> INSTRUCTIONS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instructionsUrl").getter(getter(GetAccountActivityResponse::instructionsUrl))
            .setter(setter(Builder::instructionsUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionsUrl").build()).build();

    private static final SdkField<ActivityReward> REWARD_FIELD = SdkField.<ActivityReward> builder(MarshallingType.SDK_POJO)
            .memberName("reward").getter(getter(GetAccountActivityResponse::reward)).setter(setter(Builder::reward))
            .constructor(ActivityReward::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reward").build()).build();

    private static final SdkField<Integer> ESTIMATED_TIME_TO_COMPLETE_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("estimatedTimeToCompleteInMinutes")
            .getter(getter(GetAccountActivityResponse::estimatedTimeToCompleteInMinutes))
            .setter(setter(Builder::estimatedTimeToCompleteInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedTimeToCompleteInMinutes")
                    .build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt")
            .getter(getter(GetAccountActivityResponse::expiresAt))
            .setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetAccountActivityResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedAt")
            .getter(getter(GetAccountActivityResponse::completedAt))
            .setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ID_FIELD,
            TITLE_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, INSTRUCTIONS_URL_FIELD, REWARD_FIELD,
            ESTIMATED_TIME_TO_COMPLETE_IN_MINUTES_FIELD, EXPIRES_AT_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String activityId;

    private final String title;

    private final String description;

    private final String status;

    private final String instructionsUrl;

    private final ActivityReward reward;

    private final Integer estimatedTimeToCompleteInMinutes;

    private final Instant expiresAt;

    private final Instant startedAt;

    private final Instant completedAt;

    private GetAccountActivityResponse(BuilderImpl builder) {
        super(builder);
        this.activityId = builder.activityId;
        this.title = builder.title;
        this.description = builder.description;
        this.status = builder.status;
        this.instructionsUrl = builder.instructionsUrl;
        this.reward = builder.reward;
        this.estimatedTimeToCompleteInMinutes = builder.estimatedTimeToCompleteInMinutes;
        this.expiresAt = builder.expiresAt;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
    }

    /**
     * <p>
     * A unique identifier that identifies the activity.
     * </p>
     * 
     * @return A unique identifier that identifies the activity.
     */
    public final String activityId() {
        return activityId;
    }

    /**
     * <p>
     * A short activity title.
     * </p>
     * 
     * @return A short activity title.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Provides detailed information about the activity and its expected outcomes.
     * </p>
     * 
     * @return Provides detailed information about the activity and its expected outcomes.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current activity status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current activity status.
     * @see ActivityStatus
     */
    public final ActivityStatus status() {
        return ActivityStatus.fromValue(status);
    }

    /**
     * <p>
     * The current activity status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current activity status.
     * @see ActivityStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The URL resource that provides guidance on activity requirements and completion.
     * </p>
     * 
     * @return The URL resource that provides guidance on activity requirements and completion.
     */
    public final String instructionsUrl() {
        return instructionsUrl;
    }

    /**
     * <p>
     * A reward granted upon activity completion.
     * </p>
     * 
     * @return A reward granted upon activity completion.
     */
    public final ActivityReward reward() {
        return reward;
    }

    /**
     * <p>
     * The estimated time to complete the activity. This is the duration in minutes.
     * </p>
     * 
     * @return The estimated time to complete the activity. This is the duration in minutes.
     */
    public final Integer estimatedTimeToCompleteInMinutes() {
        return estimatedTimeToCompleteInMinutes;
    }

    /**
     * <p>
     * The time by which the activity must be completed to receive a reward.
     * </p>
     * 
     * @return The time by which the activity must be completed to receive a reward.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * The timestamp when the activity started. This field appears only for activities in the <code>IN_PROGRESS</code>
     * or <code>COMPLETED</code> states.
     * </p>
     * 
     * @return The timestamp when the activity started. This field appears only for activities in the
     *         <code>IN_PROGRESS</code> or <code>COMPLETED</code> states.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The timestamp when the activity is completed. This field appears only for activities in the
     * <code>COMPLETED</code> state.
     * </p>
     * 
     * @return The timestamp when the activity is completed. This field appears only for activities in the
     *         <code>COMPLETED</code> state.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activityId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instructionsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(reward());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeToCompleteInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountActivityResponse)) {
            return false;
        }
        GetAccountActivityResponse other = (GetAccountActivityResponse) obj;
        return Objects.equals(activityId(), other.activityId()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(instructionsUrl(), other.instructionsUrl()) && Objects.equals(reward(), other.reward())
                && Objects.equals(estimatedTimeToCompleteInMinutes(), other.estimatedTimeToCompleteInMinutes())
                && Objects.equals(expiresAt(), other.expiresAt()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(completedAt(), other.completedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountActivityResponse").add("ActivityId", activityId()).add("Title", title())
                .add("Description", description()).add("Status", statusAsString()).add("InstructionsUrl", instructionsUrl())
                .add("Reward", reward()).add("EstimatedTimeToCompleteInMinutes", estimatedTimeToCompleteInMinutes())
                .add("ExpiresAt", expiresAt()).add("StartedAt", startedAt()).add("CompletedAt", completedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activityId":
            return Optional.ofNullable(clazz.cast(activityId()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "instructionsUrl":
            return Optional.ofNullable(clazz.cast(instructionsUrl()));
        case "reward":
            return Optional.ofNullable(clazz.cast(reward()));
        case "estimatedTimeToCompleteInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedTimeToCompleteInMinutes()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "completedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activityId", ACTIVITY_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("instructionsUrl", INSTRUCTIONS_URL_FIELD);
        map.put("reward", REWARD_FIELD);
        map.put("estimatedTimeToCompleteInMinutes", ESTIMATED_TIME_TO_COMPLETE_IN_MINUTES_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountActivityResponse, T> g) {
        return obj -> g.apply((GetAccountActivityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FreeTierResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountActivityResponse> {
        /**
         * <p>
         * A unique identifier that identifies the activity.
         * </p>
         * 
         * @param activityId
         *        A unique identifier that identifies the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * A short activity title.
         * </p>
         * 
         * @param title
         *        A short activity title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Provides detailed information about the activity and its expected outcomes.
         * </p>
         * 
         * @param description
         *        Provides detailed information about the activity and its expected outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current activity status.
         * </p>
         * 
         * @param status
         *        The current activity status.
         * @see ActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current activity status.
         * </p>
         * 
         * @param status
         *        The current activity status.
         * @see ActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStatus
         */
        Builder status(ActivityStatus status);

        /**
         * <p>
         * The URL resource that provides guidance on activity requirements and completion.
         * </p>
         * 
         * @param instructionsUrl
         *        The URL resource that provides guidance on activity requirements and completion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructionsUrl(String instructionsUrl);

        /**
         * <p>
         * A reward granted upon activity completion.
         * </p>
         * 
         * @param reward
         *        A reward granted upon activity completion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reward(ActivityReward reward);

        /**
         * <p>
         * A reward granted upon activity completion.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActivityReward.Builder} avoiding the need
         * to create one manually via {@link ActivityReward#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityReward.Builder#build()} is called immediately and its
         * result is passed to {@link #reward(ActivityReward)}.
         * 
         * @param reward
         *        a consumer that will call methods on {@link ActivityReward.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reward(ActivityReward)
         */
        default Builder reward(Consumer<ActivityReward.Builder> reward) {
            return reward(ActivityReward.builder().applyMutation(reward).build());
        }

        /**
         * <p>
         * The estimated time to complete the activity. This is the duration in minutes.
         * </p>
         * 
         * @param estimatedTimeToCompleteInMinutes
         *        The estimated time to complete the activity. This is the duration in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeToCompleteInMinutes(Integer estimatedTimeToCompleteInMinutes);

        /**
         * <p>
         * The time by which the activity must be completed to receive a reward.
         * </p>
         * 
         * @param expiresAt
         *        The time by which the activity must be completed to receive a reward.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * The timestamp when the activity started. This field appears only for activities in the
         * <code>IN_PROGRESS</code> or <code>COMPLETED</code> states.
         * </p>
         * 
         * @param startedAt
         *        The timestamp when the activity started. This field appears only for activities in the
         *        <code>IN_PROGRESS</code> or <code>COMPLETED</code> states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The timestamp when the activity is completed. This field appears only for activities in the
         * <code>COMPLETED</code> state.
         * </p>
         * 
         * @param completedAt
         *        The timestamp when the activity is completed. This field appears only for activities in the
         *        <code>COMPLETED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);
    }

    static final class BuilderImpl extends FreeTierResponse.BuilderImpl implements Builder {
        private String activityId;

        private String title;

        private String description;

        private String status;

        private String instructionsUrl;

        private ActivityReward reward;

        private Integer estimatedTimeToCompleteInMinutes;

        private Instant expiresAt;

        private Instant startedAt;

        private Instant completedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountActivityResponse model) {
            super(model);
            activityId(model.activityId);
            title(model.title);
            description(model.description);
            status(model.status);
            instructionsUrl(model.instructionsUrl);
            reward(model.reward);
            estimatedTimeToCompleteInMinutes(model.estimatedTimeToCompleteInMinutes);
            expiresAt(model.expiresAt);
            startedAt(model.startedAt);
            completedAt(model.completedAt);
        }

        public final String getActivityId() {
            return activityId;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActivityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getInstructionsUrl() {
            return instructionsUrl;
        }

        public final void setInstructionsUrl(String instructionsUrl) {
            this.instructionsUrl = instructionsUrl;
        }

        @Override
        public final Builder instructionsUrl(String instructionsUrl) {
            this.instructionsUrl = instructionsUrl;
            return this;
        }

        public final ActivityReward.Builder getReward() {
            return reward != null ? reward.toBuilder() : null;
        }

        public final void setReward(ActivityReward.BuilderImpl reward) {
            this.reward = reward != null ? reward.build() : null;
        }

        @Override
        public final Builder reward(ActivityReward reward) {
            this.reward = reward;
            return this;
        }

        public final Integer getEstimatedTimeToCompleteInMinutes() {
            return estimatedTimeToCompleteInMinutes;
        }

        public final void setEstimatedTimeToCompleteInMinutes(Integer estimatedTimeToCompleteInMinutes) {
            this.estimatedTimeToCompleteInMinutes = estimatedTimeToCompleteInMinutes;
        }

        @Override
        public final Builder estimatedTimeToCompleteInMinutes(Integer estimatedTimeToCompleteInMinutes) {
            this.estimatedTimeToCompleteInMinutes = estimatedTimeToCompleteInMinutes;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        @Override
        public GetAccountActivityResponse build() {
            return new GetAccountActivityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
