/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.freetier.model.ActivityReward;
import software.amazon.awssdk.services.freetier.model.ActivityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivitySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActivitySummary> {
    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activityId").getter(ActivitySummary.getter(ActivitySummary::activityId)).setter(ActivitySummary.setter(Builder::activityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(ActivitySummary.getter(ActivitySummary::title)).setter(ActivitySummary.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<ActivityReward> REWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reward").getter(ActivitySummary.getter(ActivitySummary::reward)).setter(ActivitySummary.setter(Builder::reward)).constructor(ActivityReward::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reward").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ActivitySummary.getter(ActivitySummary::statusAsString)).setter(ActivitySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ID_FIELD, TITLE_FIELD, REWARD_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActivitySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String activityId;
    private final String title;
    private final ActivityReward reward;
    private final String status;

    private ActivitySummary(BuilderImpl builder) {
        this.activityId = builder.activityId;
        this.title = builder.title;
        this.reward = builder.reward;
        this.status = builder.status;
    }

    public final String activityId() {
        return this.activityId;
    }

    public final String title() {
        return this.title;
    }

    public final ActivityReward reward() {
        return this.reward;
    }

    public final ActivityStatus status() {
        return ActivityStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.reward());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivitySummary)) {
            return false;
        }
        ActivitySummary other = (ActivitySummary)obj;
        return Objects.equals(this.activityId(), other.activityId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.reward(), other.reward()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ActivitySummary").add("ActivityId", (Object)this.activityId()).add("Title", (Object)this.title()).add("Reward", (Object)this.reward()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activityId": {
                return Optional.ofNullable(clazz.cast(this.activityId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "reward": {
                return Optional.ofNullable(clazz.cast(this.reward()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activityId", ACTIVITY_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("reward", REWARD_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActivitySummary, T> g) {
        return obj -> g.apply((ActivitySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activityId;
        private String title;
        private ActivityReward reward;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivitySummary model) {
            this.activityId(model.activityId);
            this.title(model.title);
            this.reward(model.reward);
            this.status(model.status);
        }

        public final String getActivityId() {
            return this.activityId;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final ActivityReward.Builder getReward() {
            return this.reward != null ? this.reward.toBuilder() : null;
        }

        public final void setReward(ActivityReward.BuilderImpl reward) {
            this.reward = reward != null ? reward.build() : null;
        }

        @Override
        public final Builder reward(ActivityReward reward) {
            this.reward = reward;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActivityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ActivitySummary build() {
            return new ActivitySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActivitySummary> {
        public Builder activityId(String var1);

        public Builder title(String var1);

        public Builder reward(ActivityReward var1);

        default public Builder reward(Consumer<ActivityReward.Builder> reward) {
            return this.reward((ActivityReward)((ActivityReward.Builder)ActivityReward.builder().applyMutation(reward)).build());
        }

        public Builder status(String var1);

        public Builder status(ActivityStatus var1);
    }
}

