/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccountPlanType {
    FREE("FREE"),
    PAID("PAID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccountPlanType> VALUE_MAP;
    private final String value;

    private AccountPlanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountPlanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountPlanType> knownValues() {
        EnumSet<AccountPlanType> knownValues = EnumSet.allOf(AccountPlanType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccountPlanType.class, AccountPlanType::toString);
    }
}

