/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.freetier.DefaultFreeTierAsyncClientBuilder;
import software.amazon.awssdk.services.freetier.FreeTierAsyncClientBuilder;
import software.amazon.awssdk.services.freetier.FreeTierServiceClientConfiguration;
import software.amazon.awssdk.services.freetier.model.GetAccountActivityRequest;
import software.amazon.awssdk.services.freetier.model.GetAccountActivityResponse;
import software.amazon.awssdk.services.freetier.model.GetAccountPlanStateRequest;
import software.amazon.awssdk.services.freetier.model.GetAccountPlanStateResponse;
import software.amazon.awssdk.services.freetier.model.GetFreeTierUsageRequest;
import software.amazon.awssdk.services.freetier.model.GetFreeTierUsageResponse;
import software.amazon.awssdk.services.freetier.model.ListAccountActivitiesRequest;
import software.amazon.awssdk.services.freetier.model.ListAccountActivitiesResponse;
import software.amazon.awssdk.services.freetier.model.UpgradeAccountPlanRequest;
import software.amazon.awssdk.services.freetier.model.UpgradeAccountPlanResponse;
import software.amazon.awssdk.services.freetier.paginators.GetFreeTierUsagePublisher;
import software.amazon.awssdk.services.freetier.paginators.ListAccountActivitiesPublisher;

@SdkPublicApi
@ThreadSafe
public interface FreeTierAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "freetier";
    public static final String SERVICE_METADATA_ID = "freetier";

    default public CompletableFuture<GetAccountActivityResponse> getAccountActivity(GetAccountActivityRequest getAccountActivityRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetAccountActivityResponse> getAccountActivity(Consumer<GetAccountActivityRequest.Builder> getAccountActivityRequest) {
        return this.getAccountActivity((GetAccountActivityRequest)((Object)((GetAccountActivityRequest.Builder)GetAccountActivityRequest.builder().applyMutation(getAccountActivityRequest)).build()));
    }

    default public CompletableFuture<GetAccountPlanStateResponse> getAccountPlanState(GetAccountPlanStateRequest getAccountPlanStateRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetAccountPlanStateResponse> getAccountPlanState(Consumer<GetAccountPlanStateRequest.Builder> getAccountPlanStateRequest) {
        return this.getAccountPlanState((GetAccountPlanStateRequest)((Object)((GetAccountPlanStateRequest.Builder)GetAccountPlanStateRequest.builder().applyMutation(getAccountPlanStateRequest)).build()));
    }

    default public CompletableFuture<GetFreeTierUsageResponse> getFreeTierUsage(GetFreeTierUsageRequest getFreeTierUsageRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetFreeTierUsageResponse> getFreeTierUsage(Consumer<GetFreeTierUsageRequest.Builder> getFreeTierUsageRequest) {
        return this.getFreeTierUsage((GetFreeTierUsageRequest)((Object)((GetFreeTierUsageRequest.Builder)GetFreeTierUsageRequest.builder().applyMutation(getFreeTierUsageRequest)).build()));
    }

    default public GetFreeTierUsagePublisher getFreeTierUsagePaginator(GetFreeTierUsageRequest getFreeTierUsageRequest) {
        return new GetFreeTierUsagePublisher(this, getFreeTierUsageRequest);
    }

    default public GetFreeTierUsagePublisher getFreeTierUsagePaginator(Consumer<GetFreeTierUsageRequest.Builder> getFreeTierUsageRequest) {
        return this.getFreeTierUsagePaginator((GetFreeTierUsageRequest)((Object)((GetFreeTierUsageRequest.Builder)GetFreeTierUsageRequest.builder().applyMutation(getFreeTierUsageRequest)).build()));
    }

    default public CompletableFuture<ListAccountActivitiesResponse> listAccountActivities(ListAccountActivitiesRequest listAccountActivitiesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListAccountActivitiesResponse> listAccountActivities(Consumer<ListAccountActivitiesRequest.Builder> listAccountActivitiesRequest) {
        return this.listAccountActivities((ListAccountActivitiesRequest)((Object)((ListAccountActivitiesRequest.Builder)ListAccountActivitiesRequest.builder().applyMutation(listAccountActivitiesRequest)).build()));
    }

    default public ListAccountActivitiesPublisher listAccountActivitiesPaginator(ListAccountActivitiesRequest listAccountActivitiesRequest) {
        return new ListAccountActivitiesPublisher(this, listAccountActivitiesRequest);
    }

    default public ListAccountActivitiesPublisher listAccountActivitiesPaginator(Consumer<ListAccountActivitiesRequest.Builder> listAccountActivitiesRequest) {
        return this.listAccountActivitiesPaginator((ListAccountActivitiesRequest)((Object)((ListAccountActivitiesRequest.Builder)ListAccountActivitiesRequest.builder().applyMutation(listAccountActivitiesRequest)).build()));
    }

    default public CompletableFuture<UpgradeAccountPlanResponse> upgradeAccountPlan(UpgradeAccountPlanRequest upgradeAccountPlanRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpgradeAccountPlanResponse> upgradeAccountPlan(Consumer<UpgradeAccountPlanRequest.Builder> upgradeAccountPlanRequest) {
        return this.upgradeAccountPlan((UpgradeAccountPlanRequest)((Object)((UpgradeAccountPlanRequest.Builder)UpgradeAccountPlanRequest.builder().applyMutation(upgradeAccountPlanRequest)).build()));
    }

    default public FreeTierServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static FreeTierAsyncClient create() {
        return (FreeTierAsyncClient)FreeTierAsyncClient.builder().build();
    }

    public static FreeTierAsyncClientBuilder builder() {
        return new DefaultFreeTierAsyncClientBuilder();
    }
}

