/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class FreeTierEndpointParams
implements ToCopyableBuilder<Builder, FreeTierEndpointParams> {
    private final Region region;
    private final Boolean useFIPS;
    private final String endpoint;

    private FreeTierEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return this.region;
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Region region;
        private Boolean useFIPS = false;
        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeTierEndpointParams builder) {
            this.region = builder.region;
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public FreeTierEndpointParams build() {
            return new FreeTierEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FreeTierEndpointParams> {
        public Builder region(Region var1);

        public Builder useFips(Boolean var1);

        public Builder endpoint(String var1);

        public FreeTierEndpointParams build();
    }
}

