/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.frauddetector.model.MapOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluatedExternalModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluatedExternalModel> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelEndpoint").getter(EvaluatedExternalModel.getter(EvaluatedExternalModel::modelEndpoint)).setter(EvaluatedExternalModel.setter(Builder::modelEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()}).build();
    private static final SdkField<Boolean> USE_EVENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useEventVariables").getter(EvaluatedExternalModel.getter(EvaluatedExternalModel::useEventVariables)).setter(EvaluatedExternalModel.setter(Builder::useEventVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useEventVariables").build()}).build();
    private static final SdkField<Map<String, String>> INPUT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("inputVariables").getter(EvaluatedExternalModel.getter(EvaluatedExternalModel::inputVariables)).setter(EvaluatedExternalModel.setter(Builder::inputVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> OUTPUT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("outputVariables").getter(EvaluatedExternalModel.getter(EvaluatedExternalModel::outputVariables)).setter(EvaluatedExternalModel.setter(Builder::outputVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD, USE_EVENT_VARIABLES_FIELD, INPUT_VARIABLES_FIELD, OUTPUT_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluatedExternalModel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelEndpoint;
    private final Boolean useEventVariables;
    private final Map<String, String> inputVariables;
    private final Map<String, String> outputVariables;

    private EvaluatedExternalModel(BuilderImpl builder) {
        this.modelEndpoint = builder.modelEndpoint;
        this.useEventVariables = builder.useEventVariables;
        this.inputVariables = builder.inputVariables;
        this.outputVariables = builder.outputVariables;
    }

    public final String modelEndpoint() {
        return this.modelEndpoint;
    }

    public final Boolean useEventVariables() {
        return this.useEventVariables;
    }

    public final boolean hasInputVariables() {
        return this.inputVariables != null && !(this.inputVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> inputVariables() {
        return this.inputVariables;
    }

    public final boolean hasOutputVariables() {
        return this.outputVariables != null && !(this.outputVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> outputVariables() {
        return this.outputVariables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.useEventVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputVariables() ? this.inputVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputVariables() ? this.outputVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatedExternalModel)) {
            return false;
        }
        EvaluatedExternalModel other = (EvaluatedExternalModel)obj;
        return Objects.equals(this.modelEndpoint(), other.modelEndpoint()) && Objects.equals(this.useEventVariables(), other.useEventVariables()) && this.hasInputVariables() == other.hasInputVariables() && Objects.equals(this.inputVariables(), other.inputVariables()) && this.hasOutputVariables() == other.hasOutputVariables() && Objects.equals(this.outputVariables(), other.outputVariables());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluatedExternalModel").add("ModelEndpoint", (Object)this.modelEndpoint()).add("UseEventVariables", (Object)this.useEventVariables()).add("InputVariables", (Object)(this.inputVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("OutputVariables", (Object)(this.outputVariables() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelEndpoint": {
                return Optional.ofNullable(clazz.cast(this.modelEndpoint()));
            }
            case "useEventVariables": {
                return Optional.ofNullable(clazz.cast(this.useEventVariables()));
            }
            case "inputVariables": {
                return Optional.ofNullable(clazz.cast(this.inputVariables()));
            }
            case "outputVariables": {
                return Optional.ofNullable(clazz.cast(this.outputVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelEndpoint", MODEL_ENDPOINT_FIELD);
        map.put("useEventVariables", USE_EVENT_VARIABLES_FIELD);
        map.put("inputVariables", INPUT_VARIABLES_FIELD);
        map.put("outputVariables", OUTPUT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluatedExternalModel, T> g) {
        return obj -> g.apply((EvaluatedExternalModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelEndpoint;
        private Boolean useEventVariables;
        private Map<String, String> inputVariables = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> outputVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluatedExternalModel model) {
            this.modelEndpoint(model.modelEndpoint);
            this.useEventVariables(model.useEventVariables);
            this.inputVariables(model.inputVariables);
            this.outputVariables(model.outputVariables);
        }

        public final String getModelEndpoint() {
            return this.modelEndpoint;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        @Override
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final Boolean getUseEventVariables() {
            return this.useEventVariables;
        }

        public final void setUseEventVariables(Boolean useEventVariables) {
            this.useEventVariables = useEventVariables;
        }

        @Override
        public final Builder useEventVariables(Boolean useEventVariables) {
            this.useEventVariables = useEventVariables;
            return this;
        }

        public final Map<String, String> getInputVariables() {
            if (this.inputVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.inputVariables;
        }

        public final void setInputVariables(Map<String, String> inputVariables) {
            this.inputVariables = MapOfStringsCopier.copy(inputVariables);
        }

        @Override
        public final Builder inputVariables(Map<String, String> inputVariables) {
            this.inputVariables = MapOfStringsCopier.copy(inputVariables);
            return this;
        }

        public final Map<String, String> getOutputVariables() {
            if (this.outputVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.outputVariables;
        }

        public final void setOutputVariables(Map<String, String> outputVariables) {
            this.outputVariables = MapOfStringsCopier.copy(outputVariables);
        }

        @Override
        public final Builder outputVariables(Map<String, String> outputVariables) {
            this.outputVariables = MapOfStringsCopier.copy(outputVariables);
            return this;
        }

        public EvaluatedExternalModel build() {
            return new EvaluatedExternalModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluatedExternalModel> {
        public Builder modelEndpoint(String var1);

        public Builder useEventVariables(Boolean var1);

        public Builder inputVariables(Map<String, String> var1);

        public Builder outputVariables(Map<String, String> var1);
    }
}

