/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.ModelInputDataFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelInputConfiguration> {
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(ModelInputConfiguration.getter(ModelInputConfiguration::eventTypeName)).setter(ModelInputConfiguration.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(ModelInputConfiguration.getter(ModelInputConfiguration::formatAsString)).setter(ModelInputConfiguration.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<Boolean> USE_EVENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useEventVariables").getter(ModelInputConfiguration.getter(ModelInputConfiguration::useEventVariables)).setter(ModelInputConfiguration.setter(Builder::useEventVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useEventVariables").build()}).build();
    private static final SdkField<String> JSON_INPUT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jsonInputTemplate").getter(ModelInputConfiguration.getter(ModelInputConfiguration::jsonInputTemplate)).setter(ModelInputConfiguration.setter(Builder::jsonInputTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonInputTemplate").build()}).build();
    private static final SdkField<String> CSV_INPUT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("csvInputTemplate").getter(ModelInputConfiguration.getter(ModelInputConfiguration::csvInputTemplate)).setter(ModelInputConfiguration.setter(Builder::csvInputTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csvInputTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_NAME_FIELD, FORMAT_FIELD, USE_EVENT_VARIABLES_FIELD, JSON_INPUT_TEMPLATE_FIELD, CSV_INPUT_TEMPLATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventTypeName;
    private final String format;
    private final Boolean useEventVariables;
    private final String jsonInputTemplate;
    private final String csvInputTemplate;

    private ModelInputConfiguration(BuilderImpl builder) {
        this.eventTypeName = builder.eventTypeName;
        this.format = builder.format;
        this.useEventVariables = builder.useEventVariables;
        this.jsonInputTemplate = builder.jsonInputTemplate;
        this.csvInputTemplate = builder.csvInputTemplate;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final ModelInputDataFormat format() {
        return ModelInputDataFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final Boolean useEventVariables() {
        return this.useEventVariables;
    }

    public final String jsonInputTemplate() {
        return this.jsonInputTemplate;
    }

    public final String csvInputTemplate() {
        return this.csvInputTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.useEventVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonInputTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvInputTemplate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInputConfiguration)) {
            return false;
        }
        ModelInputConfiguration other = (ModelInputConfiguration)obj;
        return Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.useEventVariables(), other.useEventVariables()) && Objects.equals(this.jsonInputTemplate(), other.jsonInputTemplate()) && Objects.equals(this.csvInputTemplate(), other.csvInputTemplate());
    }

    public final String toString() {
        return ToString.builder((String)"ModelInputConfiguration").add("EventTypeName", (Object)this.eventTypeName()).add("Format", (Object)this.formatAsString()).add("UseEventVariables", (Object)this.useEventVariables()).add("JsonInputTemplate", (Object)this.jsonInputTemplate()).add("CsvInputTemplate", (Object)this.csvInputTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "useEventVariables": {
                return Optional.ofNullable(clazz.cast(this.useEventVariables()));
            }
            case "jsonInputTemplate": {
                return Optional.ofNullable(clazz.cast(this.jsonInputTemplate()));
            }
            case "csvInputTemplate": {
                return Optional.ofNullable(clazz.cast(this.csvInputTemplate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventTypeName", EVENT_TYPE_NAME_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("useEventVariables", USE_EVENT_VARIABLES_FIELD);
        map.put("jsonInputTemplate", JSON_INPUT_TEMPLATE_FIELD);
        map.put("csvInputTemplate", CSV_INPUT_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelInputConfiguration, T> g) {
        return obj -> g.apply((ModelInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventTypeName;
        private String format;
        private Boolean useEventVariables;
        private String jsonInputTemplate;
        private String csvInputTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInputConfiguration model) {
            this.eventTypeName(model.eventTypeName);
            this.format(model.format);
            this.useEventVariables(model.useEventVariables);
            this.jsonInputTemplate(model.jsonInputTemplate);
            this.csvInputTemplate(model.csvInputTemplate);
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ModelInputDataFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Boolean getUseEventVariables() {
            return this.useEventVariables;
        }

        public final void setUseEventVariables(Boolean useEventVariables) {
            this.useEventVariables = useEventVariables;
        }

        @Override
        public final Builder useEventVariables(Boolean useEventVariables) {
            this.useEventVariables = useEventVariables;
            return this;
        }

        public final String getJsonInputTemplate() {
            return this.jsonInputTemplate;
        }

        public final void setJsonInputTemplate(String jsonInputTemplate) {
            this.jsonInputTemplate = jsonInputTemplate;
        }

        @Override
        public final Builder jsonInputTemplate(String jsonInputTemplate) {
            this.jsonInputTemplate = jsonInputTemplate;
            return this;
        }

        public final String getCsvInputTemplate() {
            return this.csvInputTemplate;
        }

        public final void setCsvInputTemplate(String csvInputTemplate) {
            this.csvInputTemplate = csvInputTemplate;
        }

        @Override
        public final Builder csvInputTemplate(String csvInputTemplate) {
            this.csvInputTemplate = csvInputTemplate;
            return this;
        }

        public ModelInputConfiguration build() {
            return new ModelInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelInputConfiguration> {
        public Builder eventTypeName(String var1);

        public Builder format(String var1);

        public Builder format(ModelInputDataFormat var1);

        public Builder useEventVariables(Boolean var1);

        public Builder jsonInputTemplate(String var1);

        public Builder csvInputTemplate(String var1);
    }
}

