/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteEventsByEventTypeResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, DeleteEventsByEventTypeResponse> {
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(DeleteEventsByEventTypeResponse.getter(DeleteEventsByEventTypeResponse::eventTypeName)).setter(DeleteEventsByEventTypeResponse.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> EVENTS_DELETION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventsDeletionStatus").getter(DeleteEventsByEventTypeResponse.getter(DeleteEventsByEventTypeResponse::eventsDeletionStatus)).setter(DeleteEventsByEventTypeResponse.setter(Builder::eventsDeletionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventsDeletionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_NAME_FIELD, EVENTS_DELETION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteEventsByEventTypeResponse.memberNameToFieldInitializer();
    private final String eventTypeName;
    private final String eventsDeletionStatus;

    private DeleteEventsByEventTypeResponse(BuilderImpl builder) {
        super(builder);
        this.eventTypeName = builder.eventTypeName;
        this.eventsDeletionStatus = builder.eventsDeletionStatus;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final String eventsDeletionStatus() {
        return this.eventsDeletionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsDeletionStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEventsByEventTypeResponse)) {
            return false;
        }
        DeleteEventsByEventTypeResponse other = (DeleteEventsByEventTypeResponse)((Object)obj);
        return Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.eventsDeletionStatus(), other.eventsDeletionStatus());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteEventsByEventTypeResponse").add("EventTypeName", (Object)this.eventTypeName()).add("EventsDeletionStatus", (Object)this.eventsDeletionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "eventsDeletionStatus": {
                return Optional.ofNullable(clazz.cast(this.eventsDeletionStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("eventTypeName", EVENT_TYPE_NAME_FIELD);
        map.put("eventsDeletionStatus", EVENTS_DELETION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteEventsByEventTypeResponse, T> g) {
        return obj -> g.apply((DeleteEventsByEventTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private String eventTypeName;
        private String eventsDeletionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEventsByEventTypeResponse model) {
            super(model);
            this.eventTypeName(model.eventTypeName);
            this.eventsDeletionStatus(model.eventsDeletionStatus);
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEventsDeletionStatus() {
            return this.eventsDeletionStatus;
        }

        public final void setEventsDeletionStatus(String eventsDeletionStatus) {
            this.eventsDeletionStatus = eventsDeletionStatus;
        }

        @Override
        public final Builder eventsDeletionStatus(String eventsDeletionStatus) {
            this.eventsDeletionStatus = eventsDeletionStatus;
            return this;
        }

        @Override
        public DeleteEventsByEventTypeResponse build() {
            return new DeleteEventsByEventTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteEventsByEventTypeResponse> {
        public Builder eventTypeName(String var1);

        public Builder eventsDeletionStatus(String var1);
    }
}

