/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.Outcome;
import software.amazon.awssdk.services.frauddetector.model.OutcomeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOutcomesResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetOutcomesResponse> {
    private static final SdkField<List<Outcome>> OUTCOMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outcomes").getter(GetOutcomesResponse.getter(GetOutcomesResponse::outcomes)).setter(GetOutcomesResponse.setter(Builder::outcomes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Outcome::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetOutcomesResponse.getter(GetOutcomesResponse::nextToken)).setter(GetOutcomesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTCOMES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOutcomesResponse.memberNameToFieldInitializer();
    private final List<Outcome> outcomes;
    private final String nextToken;

    private GetOutcomesResponse(BuilderImpl builder) {
        super(builder);
        this.outcomes = builder.outcomes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOutcomes() {
        return this.outcomes != null && !(this.outcomes instanceof SdkAutoConstructList);
    }

    public final List<Outcome> outcomes() {
        return this.outcomes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutcomes() ? this.outcomes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutcomesResponse)) {
            return false;
        }
        GetOutcomesResponse other = (GetOutcomesResponse)((Object)obj);
        return this.hasOutcomes() == other.hasOutcomes() && Objects.equals(this.outcomes(), other.outcomes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetOutcomesResponse").add("Outcomes", this.hasOutcomes() ? this.outcomes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outcomes": {
                return Optional.ofNullable(clazz.cast(this.outcomes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("outcomes", OUTCOMES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOutcomesResponse, T> g) {
        return obj -> g.apply((GetOutcomesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<Outcome> outcomes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutcomesResponse model) {
            super(model);
            this.outcomes(model.outcomes);
            this.nextToken(model.nextToken);
        }

        public final List<Outcome.Builder> getOutcomes() {
            List<Outcome.Builder> result = OutcomeListCopier.copyToBuilder(this.outcomes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutcomes(Collection<Outcome.BuilderImpl> outcomes) {
            this.outcomes = OutcomeListCopier.copyFromBuilder(outcomes);
        }

        @Override
        public final Builder outcomes(Collection<Outcome> outcomes) {
            this.outcomes = OutcomeListCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(Outcome ... outcomes) {
            this.outcomes(Arrays.asList(outcomes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(Consumer<Outcome.Builder> ... outcomes) {
            this.outcomes(Stream.of(outcomes).map(c -> (Outcome)((Outcome.Builder)Outcome.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetOutcomesResponse build() {
            return new GetOutcomesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOutcomesResponse> {
        public Builder outcomes(Collection<Outcome> var1);

        public Builder outcomes(Outcome ... var1);

        public Builder outcomes(Consumer<Outcome.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

