/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.DetectorVersionStatus;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.ListOfModelVersionsCopier;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.services.frauddetector.model.ModelVersion;
import software.amazon.awssdk.services.frauddetector.model.Rule;
import software.amazon.awssdk.services.frauddetector.model.RuleExecutionMode;
import software.amazon.awssdk.services.frauddetector.model.RuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDetectorVersionResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetDetectorVersionResponse> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::detectorId)).setter(GetDetectorVersionResponse.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorVersionId").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::detectorVersionId)).setter(GetDetectorVersionResponse.setter(Builder::detectorVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::description)).setter(GetDetectorVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> EXTERNAL_MODEL_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("externalModelEndpoints").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::externalModelEndpoints)).setter(GetDetectorVersionResponse.setter(Builder::externalModelEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ModelVersion>> MODEL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelVersions").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::modelVersions)).setter(GetDetectorVersionResponse.setter(Builder::modelVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::rules)).setter(GetDetectorVersionResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::statusAsString)).setter(GetDetectorVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedTime").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::lastUpdatedTime)).setter(GetDetectorVersionResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdTime").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::createdTime)).setter(GetDetectorVersionResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> RULE_EXECUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleExecutionMode").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::ruleExecutionModeAsString)).setter(GetDetectorVersionResponse.setter(Builder::ruleExecutionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionMode").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetDetectorVersionResponse.getter(GetDetectorVersionResponse::arn)).setter(GetDetectorVersionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD, DESCRIPTION_FIELD, EXTERNAL_MODEL_ENDPOINTS_FIELD, MODEL_VERSIONS_FIELD, RULES_FIELD, STATUS_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, RULE_EXECUTION_MODE_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("detectorId", DETECTOR_ID_FIELD);
            this.put("detectorVersionId", DETECTOR_VERSION_ID_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("externalModelEndpoints", EXTERNAL_MODEL_ENDPOINTS_FIELD);
            this.put("modelVersions", MODEL_VERSIONS_FIELD);
            this.put("rules", RULES_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("createdTime", CREATED_TIME_FIELD);
            this.put("ruleExecutionMode", RULE_EXECUTION_MODE_FIELD);
            this.put("arn", ARN_FIELD);
        }
    });
    private final String detectorId;
    private final String detectorVersionId;
    private final String description;
    private final List<String> externalModelEndpoints;
    private final List<ModelVersion> modelVersions;
    private final List<Rule> rules;
    private final String status;
    private final String lastUpdatedTime;
    private final String createdTime;
    private final String ruleExecutionMode;
    private final String arn;

    private GetDetectorVersionResponse(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.description = builder.description;
        this.externalModelEndpoints = builder.externalModelEndpoints;
        this.modelVersions = builder.modelVersions;
        this.rules = builder.rules;
        this.status = builder.status;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.ruleExecutionMode = builder.ruleExecutionMode;
        this.arn = builder.arn;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String detectorVersionId() {
        return this.detectorVersionId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasExternalModelEndpoints() {
        return this.externalModelEndpoints != null && !(this.externalModelEndpoints instanceof SdkAutoConstructList);
    }

    public final List<String> externalModelEndpoints() {
        return this.externalModelEndpoints;
    }

    public final boolean hasModelVersions() {
        return this.modelVersions != null && !(this.modelVersions instanceof SdkAutoConstructList);
    }

    public final List<ModelVersion> modelVersions() {
        return this.modelVersions;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public final DetectorVersionStatus status() {
        return DetectorVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final RuleExecutionMode ruleExecutionMode() {
        return RuleExecutionMode.fromValue(this.ruleExecutionMode);
    }

    public final String ruleExecutionModeAsString() {
        return this.ruleExecutionMode;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalModelEndpoints() ? this.externalModelEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVersions() ? this.modelVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleExecutionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDetectorVersionResponse)) {
            return false;
        }
        GetDetectorVersionResponse other = (GetDetectorVersionResponse)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorVersionId(), other.detectorVersionId()) && Objects.equals(this.description(), other.description()) && this.hasExternalModelEndpoints() == other.hasExternalModelEndpoints() && Objects.equals(this.externalModelEndpoints(), other.externalModelEndpoints()) && this.hasModelVersions() == other.hasModelVersions() && Objects.equals(this.modelVersions(), other.modelVersions()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.ruleExecutionModeAsString(), other.ruleExecutionModeAsString()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"GetDetectorVersionResponse").add("DetectorId", (Object)this.detectorId()).add("DetectorVersionId", (Object)this.detectorVersionId()).add("Description", (Object)this.description()).add("ExternalModelEndpoints", this.hasExternalModelEndpoints() ? this.externalModelEndpoints() : null).add("ModelVersions", this.hasModelVersions() ? this.modelVersions() : null).add("Rules", this.hasRules() ? this.rules() : null).add("Status", (Object)this.statusAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedTime", (Object)this.createdTime()).add("RuleExecutionMode", (Object)this.ruleExecutionModeAsString()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorVersionId": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "externalModelEndpoints": {
                return Optional.ofNullable(clazz.cast(this.externalModelEndpoints()));
            }
            case "modelVersions": {
                return Optional.ofNullable(clazz.cast(this.modelVersions()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "ruleExecutionMode": {
                return Optional.ofNullable(clazz.cast(this.ruleExecutionModeAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDetectorVersionResponse, T> g) {
        return obj -> g.apply((GetDetectorVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private String detectorId;
        private String detectorVersionId;
        private String description;
        private List<String> externalModelEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<ModelVersion> modelVersions = DefaultSdkAutoConstructList.getInstance();
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String lastUpdatedTime;
        private String createdTime;
        private String ruleExecutionMode;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDetectorVersionResponse model) {
            super(model);
            this.detectorId(model.detectorId);
            this.detectorVersionId(model.detectorVersionId);
            this.description(model.description);
            this.externalModelEndpoints(model.externalModelEndpoints);
            this.modelVersions(model.modelVersions);
            this.rules(model.rules);
            this.status(model.status);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdTime(model.createdTime);
            this.ruleExecutionMode(model.ruleExecutionMode);
            this.arn(model.arn);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return this.detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getExternalModelEndpoints() {
            if (this.externalModelEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.externalModelEndpoints;
        }

        public final void setExternalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
        }

        @Override
        public final Builder externalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalModelEndpoints(String ... externalModelEndpoints) {
            this.externalModelEndpoints(Arrays.asList(externalModelEndpoints));
            return this;
        }

        public final List<ModelVersion.Builder> getModelVersions() {
            List<ModelVersion.Builder> result = ListOfModelVersionsCopier.copyToBuilder(this.modelVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVersions(Collection<ModelVersion.BuilderImpl> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copyFromBuilder(modelVersions);
        }

        @Override
        public final Builder modelVersions(Collection<ModelVersion> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copy(modelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(ModelVersion ... modelVersions) {
            this.modelVersions(Arrays.asList(modelVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(Consumer<ModelVersion.Builder> ... modelVersions) {
            this.modelVersions(Stream.of(modelVersions).map(c -> (ModelVersion)((ModelVersion.Builder)ModelVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DetectorVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getRuleExecutionMode() {
            return this.ruleExecutionMode;
        }

        public final void setRuleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
        }

        @Override
        public final Builder ruleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
            return this;
        }

        @Override
        public final Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode) {
            this.ruleExecutionMode(ruleExecutionMode == null ? null : ruleExecutionMode.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public GetDetectorVersionResponse build() {
            return new GetDetectorVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDetectorVersionResponse> {
        public Builder detectorId(String var1);

        public Builder detectorVersionId(String var1);

        public Builder description(String var1);

        public Builder externalModelEndpoints(Collection<String> var1);

        public Builder externalModelEndpoints(String ... var1);

        public Builder modelVersions(Collection<ModelVersion> var1);

        public Builder modelVersions(ModelVersion ... var1);

        public Builder modelVersions(Consumer<ModelVersion.Builder> ... var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(DetectorVersionStatus var1);

        public Builder lastUpdatedTime(String var1);

        public Builder createdTime(String var1);

        public Builder ruleExecutionMode(String var1);

        public Builder ruleExecutionMode(RuleExecutionMode var1);

        public Builder arn(String var1);
    }
}

