/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventLabelRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, UpdateEventLabelRequest> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(UpdateEventLabelRequest.getter(UpdateEventLabelRequest::eventId)).setter(UpdateEventLabelRequest.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(UpdateEventLabelRequest.getter(UpdateEventLabelRequest::eventTypeName)).setter(UpdateEventLabelRequest.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> ASSIGNED_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assignedLabel").getter(UpdateEventLabelRequest.getter(UpdateEventLabelRequest::assignedLabel)).setter(UpdateEventLabelRequest.setter(Builder::assignedLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedLabel").build()}).build();
    private static final SdkField<String> LABEL_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("labelTimestamp").getter(UpdateEventLabelRequest.getter(UpdateEventLabelRequest::labelTimestamp)).setter(UpdateEventLabelRequest.setter(Builder::labelTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_TYPE_NAME_FIELD, ASSIGNED_LABEL_FIELD, LABEL_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventId", EVENT_ID_FIELD);
            this.put("eventTypeName", EVENT_TYPE_NAME_FIELD);
            this.put("assignedLabel", ASSIGNED_LABEL_FIELD);
            this.put("labelTimestamp", LABEL_TIMESTAMP_FIELD);
        }
    });
    private final String eventId;
    private final String eventTypeName;
    private final String assignedLabel;
    private final String labelTimestamp;

    private UpdateEventLabelRequest(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.assignedLabel = builder.assignedLabel;
        this.labelTimestamp = builder.labelTimestamp;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final String assignedLabel() {
        return this.assignedLabel;
    }

    public final String labelTimestamp() {
        return this.labelTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignedLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventLabelRequest)) {
            return false;
        }
        UpdateEventLabelRequest other = (UpdateEventLabelRequest)((Object)obj);
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.assignedLabel(), other.assignedLabel()) && Objects.equals(this.labelTimestamp(), other.labelTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventLabelRequest").add("EventId", (Object)this.eventId()).add("EventTypeName", (Object)this.eventTypeName()).add("AssignedLabel", (Object)this.assignedLabel()).add("LabelTimestamp", (Object)this.labelTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "assignedLabel": {
                return Optional.ofNullable(clazz.cast(this.assignedLabel()));
            }
            case "labelTimestamp": {
                return Optional.ofNullable(clazz.cast(this.labelTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventLabelRequest, T> g) {
        return obj -> g.apply((UpdateEventLabelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String eventId;
        private String eventTypeName;
        private String assignedLabel;
        private String labelTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventLabelRequest model) {
            super(model);
            this.eventId(model.eventId);
            this.eventTypeName(model.eventTypeName);
            this.assignedLabel(model.assignedLabel);
            this.labelTimestamp(model.labelTimestamp);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getAssignedLabel() {
            return this.assignedLabel;
        }

        public final void setAssignedLabel(String assignedLabel) {
            this.assignedLabel = assignedLabel;
        }

        @Override
        public final Builder assignedLabel(String assignedLabel) {
            this.assignedLabel = assignedLabel;
            return this;
        }

        public final String getLabelTimestamp() {
            return this.labelTimestamp;
        }

        public final void setLabelTimestamp(String labelTimestamp) {
            this.labelTimestamp = labelTimestamp;
        }

        @Override
        public final Builder labelTimestamp(String labelTimestamp) {
            this.labelTimestamp = labelTimestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventLabelRequest build() {
            return new UpdateEventLabelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventLabelRequest> {
        public Builder eventId(String var1);

        public Builder eventTypeName(String var1);

        public Builder assignedLabel(String var1);

        public Builder labelTimestamp(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

