/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse;

public class GetEventTypesPublisher
implements SdkPublisher<GetEventTypesResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetEventTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetEventTypesPublisher(FraudDetectorAsyncClient client, GetEventTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetEventTypesPublisher(FraudDetectorAsyncClient client, GetEventTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetEventTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetEventTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetEventTypesResponseFetcher
    implements AsyncPageFetcher<GetEventTypesResponse> {
        private GetEventTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetEventTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetEventTypesResponse> nextPage(GetEventTypesResponse previousPage) {
            if (previousPage == null) {
                return GetEventTypesPublisher.this.client.getEventTypes(GetEventTypesPublisher.this.firstRequest);
            }
            return GetEventTypesPublisher.this.client.getEventTypes((GetEventTypesRequest)((Object)GetEventTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

