/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.model.GetListElementsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetListElementsResponse;

public class GetListElementsIterable
implements SdkIterable<GetListElementsResponse> {
    private final FraudDetectorClient client;
    private final GetListElementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetListElementsIterable(FraudDetectorClient client, GetListElementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetListElementsResponseFetcher();
    }

    public Iterator<GetListElementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetListElementsResponseFetcher
    implements SyncPageFetcher<GetListElementsResponse> {
        private GetListElementsResponseFetcher() {
        }

        public boolean hasNextPage(GetListElementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetListElementsResponse nextPage(GetListElementsResponse previousPage) {
            if (previousPage == null) {
                return GetListElementsIterable.this.client.getListElements(GetListElementsIterable.this.firstRequest);
            }
            return GetListElementsIterable.this.client.getListElements((GetListElementsRequest)((Object)GetListElementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

