/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.AggregatedVariablesImportanceMetrics;
import software.amazon.awssdk.services.frauddetector.model.DataValidationMetrics;
import software.amazon.awssdk.services.frauddetector.model.TrainingMetricsV2;
import software.amazon.awssdk.services.frauddetector.model.VariableImportanceMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingResultV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingResultV2> {
    private static final SdkField<DataValidationMetrics> DATA_VALIDATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataValidationMetrics").getter(TrainingResultV2.getter(TrainingResultV2::dataValidationMetrics)).setter(TrainingResultV2.setter(Builder::dataValidationMetrics)).constructor(DataValidationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataValidationMetrics").build()}).build();
    private static final SdkField<TrainingMetricsV2> TRAINING_METRICS_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingMetricsV2").getter(TrainingResultV2.getter(TrainingResultV2::trainingMetricsV2)).setter(TrainingResultV2.setter(Builder::trainingMetricsV2)).constructor(TrainingMetricsV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMetricsV2").build()}).build();
    private static final SdkField<VariableImportanceMetrics> VARIABLE_IMPORTANCE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("variableImportanceMetrics").getter(TrainingResultV2.getter(TrainingResultV2::variableImportanceMetrics)).setter(TrainingResultV2.setter(Builder::variableImportanceMetrics)).constructor(VariableImportanceMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableImportanceMetrics").build()}).build();
    private static final SdkField<AggregatedVariablesImportanceMetrics> AGGREGATED_VARIABLES_IMPORTANCE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregatedVariablesImportanceMetrics").getter(TrainingResultV2.getter(TrainingResultV2::aggregatedVariablesImportanceMetrics)).setter(TrainingResultV2.setter(Builder::aggregatedVariablesImportanceMetrics)).constructor(AggregatedVariablesImportanceMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedVariablesImportanceMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_VALIDATION_METRICS_FIELD, TRAINING_METRICS_V2_FIELD, VARIABLE_IMPORTANCE_METRICS_FIELD, AGGREGATED_VARIABLES_IMPORTANCE_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataValidationMetrics dataValidationMetrics;
    private final TrainingMetricsV2 trainingMetricsV2;
    private final VariableImportanceMetrics variableImportanceMetrics;
    private final AggregatedVariablesImportanceMetrics aggregatedVariablesImportanceMetrics;

    private TrainingResultV2(BuilderImpl builder) {
        this.dataValidationMetrics = builder.dataValidationMetrics;
        this.trainingMetricsV2 = builder.trainingMetricsV2;
        this.variableImportanceMetrics = builder.variableImportanceMetrics;
        this.aggregatedVariablesImportanceMetrics = builder.aggregatedVariablesImportanceMetrics;
    }

    public final DataValidationMetrics dataValidationMetrics() {
        return this.dataValidationMetrics;
    }

    public final TrainingMetricsV2 trainingMetricsV2() {
        return this.trainingMetricsV2;
    }

    public final VariableImportanceMetrics variableImportanceMetrics() {
        return this.variableImportanceMetrics;
    }

    public final AggregatedVariablesImportanceMetrics aggregatedVariablesImportanceMetrics() {
        return this.aggregatedVariablesImportanceMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataValidationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingMetricsV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.variableImportanceMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatedVariablesImportanceMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingResultV2)) {
            return false;
        }
        TrainingResultV2 other = (TrainingResultV2)obj;
        return Objects.equals(this.dataValidationMetrics(), other.dataValidationMetrics()) && Objects.equals(this.trainingMetricsV2(), other.trainingMetricsV2()) && Objects.equals(this.variableImportanceMetrics(), other.variableImportanceMetrics()) && Objects.equals(this.aggregatedVariablesImportanceMetrics(), other.aggregatedVariablesImportanceMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingResultV2").add("DataValidationMetrics", (Object)this.dataValidationMetrics()).add("TrainingMetricsV2", (Object)this.trainingMetricsV2()).add("VariableImportanceMetrics", (Object)this.variableImportanceMetrics()).add("AggregatedVariablesImportanceMetrics", (Object)this.aggregatedVariablesImportanceMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataValidationMetrics": {
                return Optional.ofNullable(clazz.cast(this.dataValidationMetrics()));
            }
            case "trainingMetricsV2": {
                return Optional.ofNullable(clazz.cast(this.trainingMetricsV2()));
            }
            case "variableImportanceMetrics": {
                return Optional.ofNullable(clazz.cast(this.variableImportanceMetrics()));
            }
            case "aggregatedVariablesImportanceMetrics": {
                return Optional.ofNullable(clazz.cast(this.aggregatedVariablesImportanceMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingResultV2, T> g) {
        return obj -> g.apply((TrainingResultV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataValidationMetrics dataValidationMetrics;
        private TrainingMetricsV2 trainingMetricsV2;
        private VariableImportanceMetrics variableImportanceMetrics;
        private AggregatedVariablesImportanceMetrics aggregatedVariablesImportanceMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingResultV2 model) {
            this.dataValidationMetrics(model.dataValidationMetrics);
            this.trainingMetricsV2(model.trainingMetricsV2);
            this.variableImportanceMetrics(model.variableImportanceMetrics);
            this.aggregatedVariablesImportanceMetrics(model.aggregatedVariablesImportanceMetrics);
        }

        public final DataValidationMetrics.Builder getDataValidationMetrics() {
            return this.dataValidationMetrics != null ? this.dataValidationMetrics.toBuilder() : null;
        }

        public final void setDataValidationMetrics(DataValidationMetrics.BuilderImpl dataValidationMetrics) {
            this.dataValidationMetrics = dataValidationMetrics != null ? dataValidationMetrics.build() : null;
        }

        @Override
        public final Builder dataValidationMetrics(DataValidationMetrics dataValidationMetrics) {
            this.dataValidationMetrics = dataValidationMetrics;
            return this;
        }

        public final TrainingMetricsV2.Builder getTrainingMetricsV2() {
            return this.trainingMetricsV2 != null ? this.trainingMetricsV2.toBuilder() : null;
        }

        public final void setTrainingMetricsV2(TrainingMetricsV2.BuilderImpl trainingMetricsV2) {
            this.trainingMetricsV2 = trainingMetricsV2 != null ? trainingMetricsV2.build() : null;
        }

        @Override
        public final Builder trainingMetricsV2(TrainingMetricsV2 trainingMetricsV2) {
            this.trainingMetricsV2 = trainingMetricsV2;
            return this;
        }

        public final VariableImportanceMetrics.Builder getVariableImportanceMetrics() {
            return this.variableImportanceMetrics != null ? this.variableImportanceMetrics.toBuilder() : null;
        }

        public final void setVariableImportanceMetrics(VariableImportanceMetrics.BuilderImpl variableImportanceMetrics) {
            this.variableImportanceMetrics = variableImportanceMetrics != null ? variableImportanceMetrics.build() : null;
        }

        @Override
        public final Builder variableImportanceMetrics(VariableImportanceMetrics variableImportanceMetrics) {
            this.variableImportanceMetrics = variableImportanceMetrics;
            return this;
        }

        public final AggregatedVariablesImportanceMetrics.Builder getAggregatedVariablesImportanceMetrics() {
            return this.aggregatedVariablesImportanceMetrics != null ? this.aggregatedVariablesImportanceMetrics.toBuilder() : null;
        }

        public final void setAggregatedVariablesImportanceMetrics(AggregatedVariablesImportanceMetrics.BuilderImpl aggregatedVariablesImportanceMetrics) {
            this.aggregatedVariablesImportanceMetrics = aggregatedVariablesImportanceMetrics != null ? aggregatedVariablesImportanceMetrics.build() : null;
        }

        @Override
        public final Builder aggregatedVariablesImportanceMetrics(AggregatedVariablesImportanceMetrics aggregatedVariablesImportanceMetrics) {
            this.aggregatedVariablesImportanceMetrics = aggregatedVariablesImportanceMetrics;
            return this;
        }

        public TrainingResultV2 build() {
            return new TrainingResultV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingResultV2> {
        public Builder dataValidationMetrics(DataValidationMetrics var1);

        default public Builder dataValidationMetrics(Consumer<DataValidationMetrics.Builder> dataValidationMetrics) {
            return this.dataValidationMetrics((DataValidationMetrics)((DataValidationMetrics.Builder)DataValidationMetrics.builder().applyMutation(dataValidationMetrics)).build());
        }

        public Builder trainingMetricsV2(TrainingMetricsV2 var1);

        default public Builder trainingMetricsV2(Consumer<TrainingMetricsV2.Builder> trainingMetricsV2) {
            return this.trainingMetricsV2((TrainingMetricsV2)((TrainingMetricsV2.Builder)TrainingMetricsV2.builder().applyMutation(trainingMetricsV2)).build());
        }

        public Builder variableImportanceMetrics(VariableImportanceMetrics var1);

        default public Builder variableImportanceMetrics(Consumer<VariableImportanceMetrics.Builder> variableImportanceMetrics) {
            return this.variableImportanceMetrics((VariableImportanceMetrics)((VariableImportanceMetrics.Builder)VariableImportanceMetrics.builder().applyMutation(variableImportanceMetrics)).build());
        }

        public Builder aggregatedVariablesImportanceMetrics(AggregatedVariablesImportanceMetrics var1);

        default public Builder aggregatedVariablesImportanceMetrics(Consumer<AggregatedVariablesImportanceMetrics.Builder> aggregatedVariablesImportanceMetrics) {
            return this.aggregatedVariablesImportanceMetrics((AggregatedVariablesImportanceMetrics)((AggregatedVariablesImportanceMetrics.Builder)AggregatedVariablesImportanceMetrics.builder().applyMutation(aggregatedVariablesImportanceMetrics)).build());
        }
    }
}

