/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluatedRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluatedRule> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleId").getter(EvaluatedRule.getter(EvaluatedRule::ruleId)).setter(EvaluatedRule.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()}).build();
    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleVersion").getter(EvaluatedRule.getter(EvaluatedRule::ruleVersion)).setter(EvaluatedRule.setter(Builder::ruleVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleVersion").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(EvaluatedRule.getter(EvaluatedRule::expression)).setter(EvaluatedRule.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<String> EXPRESSION_WITH_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expressionWithValues").getter(EvaluatedRule.getter(EvaluatedRule::expressionWithValues)).setter(EvaluatedRule.setter(Builder::expressionWithValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expressionWithValues").build()}).build();
    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outcomes").getter(EvaluatedRule.getter(EvaluatedRule::outcomes)).setter(EvaluatedRule.setter(Builder::outcomes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EVALUATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("evaluated").getter(EvaluatedRule.getter(EvaluatedRule::evaluated)).setter(EvaluatedRule.setter(Builder::evaluated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluated").build()}).build();
    private static final SdkField<Boolean> MATCHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("matched").getter(EvaluatedRule.getter(EvaluatedRule::matched)).setter(EvaluatedRule.setter(Builder::matched)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matched").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD, RULE_VERSION_FIELD, EXPRESSION_FIELD, EXPRESSION_WITH_VALUES_FIELD, OUTCOMES_FIELD, EVALUATED_FIELD, MATCHED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleId;
    private final String ruleVersion;
    private final String expression;
    private final String expressionWithValues;
    private final List<String> outcomes;
    private final Boolean evaluated;
    private final Boolean matched;

    private EvaluatedRule(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.ruleVersion = builder.ruleVersion;
        this.expression = builder.expression;
        this.expressionWithValues = builder.expressionWithValues;
        this.outcomes = builder.outcomes;
        this.evaluated = builder.evaluated;
        this.matched = builder.matched;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String ruleVersion() {
        return this.ruleVersion;
    }

    public final String expression() {
        return this.expression;
    }

    public final String expressionWithValues() {
        return this.expressionWithValues;
    }

    public final boolean hasOutcomes() {
        return this.outcomes != null && !(this.outcomes instanceof SdkAutoConstructList);
    }

    public final List<String> outcomes() {
        return this.outcomes;
    }

    public final Boolean evaluated() {
        return this.evaluated;
    }

    public final Boolean matched() {
        return this.matched;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionWithValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutcomes() ? this.outcomes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluated());
        hashCode = 31 * hashCode + Objects.hashCode(this.matched());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatedRule)) {
            return false;
        }
        EvaluatedRule other = (EvaluatedRule)obj;
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.ruleVersion(), other.ruleVersion()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.expressionWithValues(), other.expressionWithValues()) && this.hasOutcomes() == other.hasOutcomes() && Objects.equals(this.outcomes(), other.outcomes()) && Objects.equals(this.evaluated(), other.evaluated()) && Objects.equals(this.matched(), other.matched());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluatedRule").add("RuleId", (Object)this.ruleId()).add("RuleVersion", (Object)this.ruleVersion()).add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("ExpressionWithValues", (Object)(this.expressionWithValues() == null ? null : "*** Sensitive Data Redacted ***")).add("Outcomes", this.hasOutcomes() ? this.outcomes() : null).add("Evaluated", (Object)this.evaluated()).add("Matched", (Object)this.matched()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "ruleVersion": {
                return Optional.ofNullable(clazz.cast(this.ruleVersion()));
            }
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "expressionWithValues": {
                return Optional.ofNullable(clazz.cast(this.expressionWithValues()));
            }
            case "outcomes": {
                return Optional.ofNullable(clazz.cast(this.outcomes()));
            }
            case "evaluated": {
                return Optional.ofNullable(clazz.cast(this.evaluated()));
            }
            case "matched": {
                return Optional.ofNullable(clazz.cast(this.matched()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluatedRule, T> g) {
        return obj -> g.apply((EvaluatedRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private String ruleVersion;
        private String expression;
        private String expressionWithValues;
        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();
        private Boolean evaluated;
        private Boolean matched;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluatedRule model) {
            this.ruleId(model.ruleId);
            this.ruleVersion(model.ruleVersion);
            this.expression(model.expression);
            this.expressionWithValues(model.expressionWithValues);
            this.outcomes(model.outcomes);
            this.evaluated(model.evaluated);
            this.matched(model.matched);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getRuleVersion() {
            return this.ruleVersion;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getExpressionWithValues() {
            return this.expressionWithValues;
        }

        public final void setExpressionWithValues(String expressionWithValues) {
            this.expressionWithValues = expressionWithValues;
        }

        @Override
        public final Builder expressionWithValues(String expressionWithValues) {
            this.expressionWithValues = expressionWithValues;
            return this;
        }

        public final Collection<String> getOutcomes() {
            if (this.outcomes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outcomes;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
        }

        @Override
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(String ... outcomes) {
            this.outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final Boolean getEvaluated() {
            return this.evaluated;
        }

        public final void setEvaluated(Boolean evaluated) {
            this.evaluated = evaluated;
        }

        @Override
        public final Builder evaluated(Boolean evaluated) {
            this.evaluated = evaluated;
            return this;
        }

        public final Boolean getMatched() {
            return this.matched;
        }

        public final void setMatched(Boolean matched) {
            this.matched = matched;
        }

        @Override
        public final Builder matched(Boolean matched) {
            this.matched = matched;
            return this;
        }

        public EvaluatedRule build() {
            return new EvaluatedRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluatedRule> {
        public Builder ruleId(String var1);

        public Builder ruleVersion(String var1);

        public Builder expression(String var1);

        public Builder expressionWithValues(String var1);

        public Builder outcomes(Collection<String> var1);

        public Builder outcomes(String ... var1);

        public Builder evaluated(Boolean var1);

        public Builder matched(Boolean var1);
    }
}

