/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.model.GetRulesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetRulesResponse;

public class GetRulesPublisher
implements SdkPublisher<GetRulesResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetRulesPublisher(FraudDetectorAsyncClient client, GetRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetRulesPublisher(FraudDetectorAsyncClient client, GetRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetRulesResponseFetcher
    implements AsyncPageFetcher<GetRulesResponse> {
        private GetRulesResponseFetcher() {
        }

        public boolean hasNextPage(GetRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetRulesResponse> nextPage(GetRulesResponse previousPage) {
            if (previousPage == null) {
                return GetRulesPublisher.this.client.getRules(GetRulesPublisher.this.firstRequest);
            }
            return GetRulesPublisher.this.client.getRules((GetRulesRequest)((Object)GetRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

