/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ListOfModelVersionEvaluationsCopier;
import software.amazon.awssdk.services.frauddetector.model.ModelVersionEvaluation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluatedModelVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluatedModelVersion> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(EvaluatedModelVersion.getter(EvaluatedModelVersion::modelId)).setter(EvaluatedModelVersion.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelVersion").getter(EvaluatedModelVersion.getter(EvaluatedModelVersion::modelVersion)).setter(EvaluatedModelVersion.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersion").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelType").getter(EvaluatedModelVersion.getter(EvaluatedModelVersion::modelType)).setter(EvaluatedModelVersion.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()}).build();
    private static final SdkField<List<ModelVersionEvaluation>> EVALUATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluations").getter(EvaluatedModelVersion.getter(EvaluatedModelVersion::evaluations)).setter(EvaluatedModelVersion.setter(Builder::evaluations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVersionEvaluation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MODEL_VERSION_FIELD, MODEL_TYPE_FIELD, EVALUATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelId;
    private final String modelVersion;
    private final String modelType;
    private final List<ModelVersionEvaluation> evaluations;

    private EvaluatedModelVersion(BuilderImpl builder) {
        this.modelId = builder.modelId;
        this.modelVersion = builder.modelVersion;
        this.modelType = builder.modelType;
        this.evaluations = builder.evaluations;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final String modelType() {
        return this.modelType;
    }

    public final boolean hasEvaluations() {
        return this.evaluations != null && !(this.evaluations instanceof SdkAutoConstructList);
    }

    public final List<ModelVersionEvaluation> evaluations() {
        return this.evaluations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluations() ? this.evaluations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatedModelVersion)) {
            return false;
        }
        EvaluatedModelVersion other = (EvaluatedModelVersion)obj;
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.modelType(), other.modelType()) && this.hasEvaluations() == other.hasEvaluations() && Objects.equals(this.evaluations(), other.evaluations());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluatedModelVersion").add("ModelId", (Object)this.modelId()).add("ModelVersion", (Object)this.modelVersion()).add("ModelType", (Object)this.modelType()).add("Evaluations", this.hasEvaluations() ? this.evaluations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "modelType": {
                return Optional.ofNullable(clazz.cast(this.modelType()));
            }
            case "evaluations": {
                return Optional.ofNullable(clazz.cast(this.evaluations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluatedModelVersion, T> g) {
        return obj -> g.apply((EvaluatedModelVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelId;
        private String modelVersion;
        private String modelType;
        private List<ModelVersionEvaluation> evaluations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluatedModelVersion model) {
            this.modelId(model.modelId);
            this.modelVersion(model.modelVersion);
            this.modelType(model.modelType);
            this.evaluations(model.evaluations);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getModelType() {
            return this.modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        public final List<ModelVersionEvaluation.Builder> getEvaluations() {
            List<ModelVersionEvaluation.Builder> result = ListOfModelVersionEvaluationsCopier.copyToBuilder(this.evaluations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluations(Collection<ModelVersionEvaluation.BuilderImpl> evaluations) {
            this.evaluations = ListOfModelVersionEvaluationsCopier.copyFromBuilder(evaluations);
        }

        @Override
        public final Builder evaluations(Collection<ModelVersionEvaluation> evaluations) {
            this.evaluations = ListOfModelVersionEvaluationsCopier.copy(evaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluations(ModelVersionEvaluation ... evaluations) {
            this.evaluations(Arrays.asList(evaluations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluations(Consumer<ModelVersionEvaluation.Builder> ... evaluations) {
            this.evaluations(Stream.of(evaluations).map(c -> (ModelVersionEvaluation)((ModelVersionEvaluation.Builder)ModelVersionEvaluation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EvaluatedModelVersion build() {
            return new EvaluatedModelVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluatedModelVersion> {
        public Builder modelId(String var1);

        public Builder modelVersion(String var1);

        public Builder modelType(String var1);

        public Builder evaluations(Collection<ModelVersionEvaluation> var1);

        public Builder evaluations(ModelVersionEvaluation ... var1);

        public Builder evaluations(Consumer<ModelVersionEvaluation.Builder> ... var1);
    }
}

