/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse;

public class GetEntityTypesIterable
implements SdkIterable<GetEntityTypesResponse> {
    private final FraudDetectorClient client;
    private final GetEntityTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetEntityTypesIterable(FraudDetectorClient client, GetEntityTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetEntityTypesResponseFetcher();
    }

    public Iterator<GetEntityTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetEntityTypesResponseFetcher
    implements SyncPageFetcher<GetEntityTypesResponse> {
        private GetEntityTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetEntityTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetEntityTypesResponse nextPage(GetEntityTypesResponse previousPage) {
            if (previousPage == null) {
                return GetEntityTypesIterable.this.client.getEntityTypes(GetEntityTypesIterable.this.firstRequest);
            }
            return GetEntityTypesIterable.this.client.getEntityTypes((GetEntityTypesRequest)((Object)GetEntityTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

