/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventPredictionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventPredictionSummary> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(EventPredictionSummary.getter(EventPredictionSummary::eventId)).setter(EventPredictionSummary.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(EventPredictionSummary.getter(EventPredictionSummary::eventTypeName)).setter(EventPredictionSummary.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTimestamp").getter(EventPredictionSummary.getter(EventPredictionSummary::eventTimestamp)).setter(EventPredictionSummary.setter(Builder::eventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()}).build();
    private static final SdkField<String> PREDICTION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("predictionTimestamp").getter(EventPredictionSummary.getter(EventPredictionSummary::predictionTimestamp)).setter(EventPredictionSummary.setter(Builder::predictionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTimestamp").build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(EventPredictionSummary.getter(EventPredictionSummary::detectorId)).setter(EventPredictionSummary.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorVersionId").getter(EventPredictionSummary.getter(EventPredictionSummary::detectorVersionId)).setter(EventPredictionSummary.setter(Builder::detectorVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_TYPE_NAME_FIELD, EVENT_TIMESTAMP_FIELD, PREDICTION_TIMESTAMP_FIELD, DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String eventTypeName;
    private final String eventTimestamp;
    private final String predictionTimestamp;
    private final String detectorId;
    private final String detectorVersionId;

    private EventPredictionSummary(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.eventTimestamp = builder.eventTimestamp;
        this.predictionTimestamp = builder.predictionTimestamp;
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final String eventTimestamp() {
        return this.eventTimestamp;
    }

    public final String predictionTimestamp() {
        return this.predictionTimestamp;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String detectorVersionId() {
        return this.detectorVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventPredictionSummary)) {
            return false;
        }
        EventPredictionSummary other = (EventPredictionSummary)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.eventTimestamp(), other.eventTimestamp()) && Objects.equals(this.predictionTimestamp(), other.predictionTimestamp()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorVersionId(), other.detectorVersionId());
    }

    public final String toString() {
        return ToString.builder((String)"EventPredictionSummary").add("EventId", (Object)this.eventId()).add("EventTypeName", (Object)this.eventTypeName()).add("EventTimestamp", (Object)this.eventTimestamp()).add("PredictionTimestamp", (Object)this.predictionTimestamp()).add("DetectorId", (Object)this.detectorId()).add("DetectorVersionId", (Object)this.detectorVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "eventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.eventTimestamp()));
            }
            case "predictionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.predictionTimestamp()));
            }
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorVersionId": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventPredictionSummary, T> g) {
        return obj -> g.apply((EventPredictionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String eventTypeName;
        private String eventTimestamp;
        private String predictionTimestamp;
        private String detectorId;
        private String detectorVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(EventPredictionSummary model) {
            this.eventId(model.eventId);
            this.eventTypeName(model.eventTypeName);
            this.eventTimestamp(model.eventTimestamp);
            this.predictionTimestamp(model.predictionTimestamp);
            this.detectorId(model.detectorId);
            this.detectorVersionId(model.detectorVersionId);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        @Transient
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        @Transient
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEventTimestamp() {
            return this.eventTimestamp;
        }

        public final void setEventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        @Transient
        public final Builder eventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getPredictionTimestamp() {
            return this.predictionTimestamp;
        }

        public final void setPredictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
        }

        @Override
        @Transient
        public final Builder predictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
            return this;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        @Transient
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return this.detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        @Transient
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public EventPredictionSummary build() {
            return new EventPredictionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventPredictionSummary> {
        public Builder eventId(String var1);

        public Builder eventTypeName(String var1);

        public Builder eventTimestamp(String var1);

        public Builder predictionTimestamp(String var1);

        public Builder detectorId(String var1);

        public Builder detectorVersionId(String var1);
    }
}

