/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelTypeEnum {
    ONLINE_FRAUD_INSIGHTS("ONLINE_FRAUD_INSIGHTS"),
    TRANSACTION_FRAUD_INSIGHTS("TRANSACTION_FRAUD_INSIGHTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelTypeEnum> VALUE_MAP;
    private final String value;

    private ModelTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelTypeEnum> knownValues() {
        EnumSet<ModelTypeEnum> knownValues = EnumSet.allOf(ModelTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelTypeEnum.class, ModelTypeEnum::toString);
    }
}

