/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ModelVersionStatus {
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    TRAINING_CANCELLED("TRAINING_CANCELLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ModelVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ModelVersionStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelVersionStatus> knownValues() {
        return Stream.of(ModelVersionStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

