/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.model.GetModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelsResponse;

public class GetModelsIterable
implements SdkIterable<GetModelsResponse> {
    private final FraudDetectorClient client;
    private final GetModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetModelsIterable(FraudDetectorClient client, GetModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetModelsResponseFetcher();
    }

    public Iterator<GetModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetModelsResponseFetcher
    implements SyncPageFetcher<GetModelsResponse> {
        private GetModelsResponseFetcher() {
        }

        public boolean hasNextPage(GetModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetModelsResponse nextPage(GetModelsResponse previousPage) {
            if (previousPage == null) {
                return GetModelsIterable.this.client.getModels(GetModelsIterable.this.firstRequest);
            }
            return GetModelsIterable.this.client.getModels((GetModelsRequest)((Object)GetModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

