/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse;

public class GetEventTypesIterable
implements SdkIterable<GetEventTypesResponse> {
    private final FraudDetectorClient client;
    private final GetEventTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetEventTypesIterable(FraudDetectorClient client, GetEventTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetEventTypesResponseFetcher();
    }

    public Iterator<GetEventTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetEventTypesResponseFetcher
    implements SyncPageFetcher<GetEventTypesResponse> {
        private GetEventTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetEventTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetEventTypesResponse nextPage(GetEventTypesResponse previousPage) {
            if (previousPage == null) {
                return GetEventTypesIterable.this.client.getEventTypes(GetEventTypesIterable.this.firstRequest);
            }
            return GetEventTypesIterable.this.client.getEventTypes((GetEventTypesRequest)((Object)GetEventTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

