/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ExternalEventsDetail;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ModelTypeEnum;
import software.amazon.awssdk.services.frauddetector.model.Tag;
import software.amazon.awssdk.services.frauddetector.model.TrainingDataSchema;
import software.amazon.awssdk.services.frauddetector.model.TrainingDataSourceEnum;
import software.amazon.awssdk.services.frauddetector.model._tagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelVersionRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, CreateModelVersionRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(CreateModelVersionRequest.getter(CreateModelVersionRequest::modelId)).setter(CreateModelVersionRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelType").getter(CreateModelVersionRequest.getter(CreateModelVersionRequest::modelTypeAsString)).setter(CreateModelVersionRequest.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()}).build();
    private static final SdkField<String> TRAINING_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingDataSource").getter(CreateModelVersionRequest.getter(CreateModelVersionRequest::trainingDataSourceAsString)).setter(CreateModelVersionRequest.setter(Builder::trainingDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSource").build()}).build();
    private static final SdkField<TrainingDataSchema> TRAINING_DATA_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingDataSchema").getter(CreateModelVersionRequest.getter(CreateModelVersionRequest::trainingDataSchema)).setter(CreateModelVersionRequest.setter(Builder::trainingDataSchema)).constructor(TrainingDataSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSchema").build()}).build();
    private static final SdkField<ExternalEventsDetail> EXTERNAL_EVENTS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalEventsDetail").getter(CreateModelVersionRequest.getter(CreateModelVersionRequest::externalEventsDetail)).setter(CreateModelVersionRequest.setter(Builder::externalEventsDetail)).constructor(ExternalEventsDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalEventsDetail").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateModelVersionRequest.getter(CreateModelVersionRequest::tags)).setter(CreateModelVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MODEL_TYPE_FIELD, TRAINING_DATA_SOURCE_FIELD, TRAINING_DATA_SCHEMA_FIELD, EXTERNAL_EVENTS_DETAIL_FIELD, TAGS_FIELD));
    private final String modelId;
    private final String modelType;
    private final String trainingDataSource;
    private final TrainingDataSchema trainingDataSchema;
    private final ExternalEventsDetail externalEventsDetail;
    private final List<Tag> tags;

    private CreateModelVersionRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.trainingDataSource = builder.trainingDataSource;
        this.trainingDataSchema = builder.trainingDataSchema;
        this.externalEventsDetail = builder.externalEventsDetail;
        this.tags = builder.tags;
    }

    public String modelId() {
        return this.modelId;
    }

    public ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(this.modelType);
    }

    public String modelTypeAsString() {
        return this.modelType;
    }

    public TrainingDataSourceEnum trainingDataSource() {
        return TrainingDataSourceEnum.fromValue(this.trainingDataSource);
    }

    public String trainingDataSourceAsString() {
        return this.trainingDataSource;
    }

    public TrainingDataSchema trainingDataSchema() {
        return this.trainingDataSchema;
    }

    public ExternalEventsDetail externalEventsDetail() {
        return this.externalEventsDetail;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalEventsDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelVersionRequest)) {
            return false;
        }
        CreateModelVersionRequest other = (CreateModelVersionRequest)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.trainingDataSourceAsString(), other.trainingDataSourceAsString()) && Objects.equals(this.trainingDataSchema(), other.trainingDataSchema()) && Objects.equals(this.externalEventsDetail(), other.externalEventsDetail()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateModelVersionRequest").add("ModelId", (Object)this.modelId()).add("ModelType", (Object)this.modelTypeAsString()).add("TrainingDataSource", (Object)this.trainingDataSourceAsString()).add("TrainingDataSchema", (Object)this.trainingDataSchema()).add("ExternalEventsDetail", (Object)this.externalEventsDetail()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "trainingDataSource": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSourceAsString()));
            }
            case "trainingDataSchema": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSchema()));
            }
            case "externalEventsDetail": {
                return Optional.ofNullable(clazz.cast(this.externalEventsDetail()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelVersionRequest, T> g) {
        return obj -> g.apply((CreateModelVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String modelId;
        private String modelType;
        private String trainingDataSource;
        private TrainingDataSchema trainingDataSchema;
        private ExternalEventsDetail externalEventsDetail;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelVersionRequest model) {
            super(model);
            this.modelId(model.modelId);
            this.modelType(model.modelType);
            this.trainingDataSource(model.trainingDataSource);
            this.trainingDataSchema(model.trainingDataSchema);
            this.externalEventsDetail(model.externalEventsDetail);
            this.tags(model.tags);
        }

        public final String getModelId() {
            return this.modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getModelType() {
            return this.modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getTrainingDataSource() {
            return this.trainingDataSource;
        }

        @Override
        public final Builder trainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        @Override
        public final Builder trainingDataSource(TrainingDataSourceEnum trainingDataSource) {
            this.trainingDataSource(trainingDataSource == null ? null : trainingDataSource.toString());
            return this;
        }

        public final void setTrainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
        }

        public final TrainingDataSchema.Builder getTrainingDataSchema() {
            return this.trainingDataSchema != null ? this.trainingDataSchema.toBuilder() : null;
        }

        @Override
        public final Builder trainingDataSchema(TrainingDataSchema trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema;
            return this;
        }

        public final void setTrainingDataSchema(TrainingDataSchema.BuilderImpl trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema != null ? trainingDataSchema.build() : null;
        }

        public final ExternalEventsDetail.Builder getExternalEventsDetail() {
            return this.externalEventsDetail != null ? this.externalEventsDetail.toBuilder() : null;
        }

        @Override
        public final Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail;
            return this;
        }

        public final void setExternalEventsDetail(ExternalEventsDetail.BuilderImpl externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail != null ? externalEventsDetail.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelVersionRequest build() {
            return new CreateModelVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelVersionRequest> {
        public Builder modelId(String var1);

        public Builder modelType(String var1);

        public Builder modelType(ModelTypeEnum var1);

        public Builder trainingDataSource(String var1);

        public Builder trainingDataSource(TrainingDataSourceEnum var1);

        public Builder trainingDataSchema(TrainingDataSchema var1);

        default public Builder trainingDataSchema(Consumer<TrainingDataSchema.Builder> trainingDataSchema) {
            return this.trainingDataSchema((TrainingDataSchema)((TrainingDataSchema.Builder)TrainingDataSchema.builder().applyMutation(trainingDataSchema)).build());
        }

        public Builder externalEventsDetail(ExternalEventsDetail var1);

        default public Builder externalEventsDetail(Consumer<ExternalEventsDetail.Builder> externalEventsDetail) {
            return this.externalEventsDetail((ExternalEventsDetail)((ExternalEventsDetail.Builder)ExternalEventsDetail.builder().applyMutation(externalEventsDetail)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

