/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.frauddetector.model.ModelPredictionMapCopier;
import software.amazon.awssdk.services.frauddetector.model.ModelVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelScores
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelScores> {
    private static final SdkField<ModelVersion> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelVersion").getter(ModelScores.getter(ModelScores::modelVersion)).setter(ModelScores.setter(Builder::modelVersion)).constructor(ModelVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersion").build()}).build();
    private static final SdkField<Map<String, Float>> SCORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("scores").getter(ModelScores.getter(ModelScores::scores)).setter(ModelScores.setter(Builder::scores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scores").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.FLOAT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VERSION_FIELD, SCORES_FIELD));
    private static final long serialVersionUID = 1L;
    private final ModelVersion modelVersion;
    private final Map<String, Float> scores;

    private ModelScores(BuilderImpl builder) {
        this.modelVersion = builder.modelVersion;
        this.scores = builder.scores;
    }

    public ModelVersion modelVersion() {
        return this.modelVersion;
    }

    public boolean hasScores() {
        return this.scores != null && !(this.scores instanceof SdkAutoConstructMap);
    }

    public Map<String, Float> scores() {
        return this.scores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.scores());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelScores)) {
            return false;
        }
        ModelScores other = (ModelScores)obj;
        return Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.scores(), other.scores());
    }

    public String toString() {
        return ToString.builder((String)"ModelScores").add("ModelVersion", (Object)this.modelVersion()).add("Scores", this.scores()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "scores": {
                return Optional.ofNullable(clazz.cast(this.scores()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelScores, T> g) {
        return obj -> g.apply((ModelScores)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ModelVersion modelVersion;
        private Map<String, Float> scores = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelScores model) {
            this.modelVersion(model.modelVersion);
            this.scores(model.scores);
        }

        public final ModelVersion.Builder getModelVersion() {
            return this.modelVersion != null ? this.modelVersion.toBuilder() : null;
        }

        @Override
        public final Builder modelVersion(ModelVersion modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(ModelVersion.BuilderImpl modelVersion) {
            this.modelVersion = modelVersion != null ? modelVersion.build() : null;
        }

        public final Map<String, Float> getScores() {
            return this.scores;
        }

        @Override
        public final Builder scores(Map<String, Float> scores) {
            this.scores = ModelPredictionMapCopier.copy(scores);
            return this;
        }

        public final void setScores(Map<String, Float> scores) {
            this.scores = ModelPredictionMapCopier.copy(scores);
        }

        public ModelScores build() {
            return new ModelScores(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelScores> {
        public Builder modelVersion(ModelVersion var1);

        default public Builder modelVersion(Consumer<ModelVersion.Builder> modelVersion) {
            return this.modelVersion((ModelVersion)((ModelVersion.Builder)ModelVersion.builder().applyMutation(modelVersion)).build());
        }

        public Builder scores(Map<String, Float> var1);
    }
}

