/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.LabelSchema;
import software.amazon.awssdk.services.frauddetector.model.ModelTypeEnum;
import software.amazon.awssdk.services.frauddetector.model.ModelVariable;
import software.amazon.awssdk.services.frauddetector.model.ModelVariablesListCopier;
import software.amazon.awssdk.services.frauddetector.model.TrainingDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutModelRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, PutModelRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutModelRequest.getter(PutModelRequest::modelId)).setter(PutModelRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutModelRequest.getter(PutModelRequest::modelTypeAsString)).setter(PutModelRequest.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutModelRequest.getter(PutModelRequest::description)).setter(PutModelRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TrainingDataSource> TRAINING_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutModelRequest.getter(PutModelRequest::trainingDataSource)).setter(PutModelRequest.setter(Builder::trainingDataSource)).constructor(TrainingDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSource").build()}).build();
    private static final SdkField<List<ModelVariable>> MODEL_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutModelRequest.getter(PutModelRequest::modelVariables)).setter(PutModelRequest.setter(Builder::modelVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LabelSchema> LABEL_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutModelRequest.getter(PutModelRequest::labelSchema)).setter(PutModelRequest.setter(Builder::labelSchema)).constructor(LabelSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MODEL_TYPE_FIELD, DESCRIPTION_FIELD, TRAINING_DATA_SOURCE_FIELD, MODEL_VARIABLES_FIELD, LABEL_SCHEMA_FIELD));
    private final String modelId;
    private final String modelType;
    private final String description;
    private final TrainingDataSource trainingDataSource;
    private final List<ModelVariable> modelVariables;
    private final LabelSchema labelSchema;

    private PutModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.description = builder.description;
        this.trainingDataSource = builder.trainingDataSource;
        this.modelVariables = builder.modelVariables;
        this.labelSchema = builder.labelSchema;
    }

    public String modelId() {
        return this.modelId;
    }

    public ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(this.modelType);
    }

    public String modelTypeAsString() {
        return this.modelType;
    }

    public String description() {
        return this.description;
    }

    public TrainingDataSource trainingDataSource() {
        return this.trainingDataSource;
    }

    public boolean hasModelVariables() {
        return this.modelVariables != null && !(this.modelVariables instanceof SdkAutoConstructList);
    }

    public List<ModelVariable> modelVariables() {
        return this.modelVariables;
    }

    public LabelSchema labelSchema() {
        return this.labelSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelSchema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutModelRequest)) {
            return false;
        }
        PutModelRequest other = (PutModelRequest)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.trainingDataSource(), other.trainingDataSource()) && Objects.equals(this.modelVariables(), other.modelVariables()) && Objects.equals(this.labelSchema(), other.labelSchema());
    }

    public String toString() {
        return ToString.builder((String)"PutModelRequest").add("ModelId", (Object)this.modelId()).add("ModelType", (Object)this.modelTypeAsString()).add("Description", (Object)this.description()).add("TrainingDataSource", (Object)this.trainingDataSource()).add("ModelVariables", this.modelVariables()).add("LabelSchema", (Object)this.labelSchema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "trainingDataSource": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSource()));
            }
            case "modelVariables": {
                return Optional.ofNullable(clazz.cast(this.modelVariables()));
            }
            case "labelSchema": {
                return Optional.ofNullable(clazz.cast(this.labelSchema()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutModelRequest, T> g) {
        return obj -> g.apply((PutModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String modelId;
        private String modelType;
        private String description;
        private TrainingDataSource trainingDataSource;
        private List<ModelVariable> modelVariables = DefaultSdkAutoConstructList.getInstance();
        private LabelSchema labelSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(PutModelRequest model) {
            super(model);
            this.modelId(model.modelId);
            this.modelType(model.modelType);
            this.description(model.description);
            this.trainingDataSource(model.trainingDataSource);
            this.modelVariables(model.modelVariables);
            this.labelSchema(model.labelSchema);
        }

        public final String getModelId() {
            return this.modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getModelType() {
            return this.modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final TrainingDataSource.Builder getTrainingDataSource() {
            return this.trainingDataSource != null ? this.trainingDataSource.toBuilder() : null;
        }

        @Override
        public final Builder trainingDataSource(TrainingDataSource trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        public final void setTrainingDataSource(TrainingDataSource.BuilderImpl trainingDataSource) {
            this.trainingDataSource = trainingDataSource != null ? trainingDataSource.build() : null;
        }

        public final Collection<ModelVariable.Builder> getModelVariables() {
            return this.modelVariables != null ? (Collection)this.modelVariables.stream().map(ModelVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modelVariables(Collection<ModelVariable> modelVariables) {
            this.modelVariables = ModelVariablesListCopier.copy(modelVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariables(ModelVariable ... modelVariables) {
            this.modelVariables(Arrays.asList(modelVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariables(Consumer<ModelVariable.Builder> ... modelVariables) {
            this.modelVariables(Stream.of(modelVariables).map(c -> (ModelVariable)((ModelVariable.Builder)ModelVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModelVariables(Collection<ModelVariable.BuilderImpl> modelVariables) {
            this.modelVariables = ModelVariablesListCopier.copyFromBuilder(modelVariables);
        }

        public final LabelSchema.Builder getLabelSchema() {
            return this.labelSchema != null ? this.labelSchema.toBuilder() : null;
        }

        @Override
        public final Builder labelSchema(LabelSchema labelSchema) {
            this.labelSchema = labelSchema;
            return this;
        }

        public final void setLabelSchema(LabelSchema.BuilderImpl labelSchema) {
            this.labelSchema = labelSchema != null ? labelSchema.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutModelRequest build() {
            return new PutModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutModelRequest> {
        public Builder modelId(String var1);

        public Builder modelType(String var1);

        public Builder modelType(ModelTypeEnum var1);

        public Builder description(String var1);

        public Builder trainingDataSource(TrainingDataSource var1);

        default public Builder trainingDataSource(Consumer<TrainingDataSource.Builder> trainingDataSource) {
            return this.trainingDataSource((TrainingDataSource)((TrainingDataSource.Builder)TrainingDataSource.builder().applyMutation(trainingDataSource)).build());
        }

        public Builder modelVariables(Collection<ModelVariable> var1);

        public Builder modelVariables(ModelVariable ... var1);

        public Builder modelVariables(Consumer<ModelVariable.Builder> ... var1);

        public Builder labelSchema(LabelSchema var1);

        default public Builder labelSchema(Consumer<LabelSchema.Builder> labelSchema) {
            return this.labelSchema((LabelSchema)((LabelSchema.Builder)LabelSchema.builder().applyMutation(labelSchema)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

