/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.model.GetRulesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetRulesResponse;

public class GetRulesIterable
implements SdkIterable<GetRulesResponse> {
    private final FraudDetectorClient client;
    private final GetRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetRulesIterable(FraudDetectorClient client, GetRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetRulesResponseFetcher();
    }

    public Iterator<GetRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetRulesResponseFetcher
    implements SyncPageFetcher<GetRulesResponse> {
        private GetRulesResponseFetcher() {
        }

        public boolean hasNextPage(GetRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetRulesResponse nextPage(GetRulesResponse previousPage) {
            if (previousPage == null) {
                return GetRulesIterable.this.client.getRules(GetRulesIterable.this.firstRequest);
            }
            return GetRulesIterable.this.client.getRules((GetRulesRequest)((Object)GetRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

