/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Detector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Detector> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Detector.getter(Detector::detectorId)).setter(Detector.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Detector.getter(Detector::description)).setter(Detector.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Detector.getter(Detector::lastUpdatedTime)).setter(Detector.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Detector.getter(Detector::createdTime)).setter(Detector.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String detectorId;
    private final String description;
    private final String lastUpdatedTime;
    private final String createdTime;

    private Detector(BuilderImpl builder) {
        this.detectorId = builder.detectorId;
        this.description = builder.description;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String description() {
        return this.description;
    }

    public String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Detector)) {
            return false;
        }
        Detector other = (Detector)obj;
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public String toString() {
        return ToString.builder((String)"Detector").add("DetectorId", (Object)this.detectorId()).add("Description", (Object)this.description()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Detector, T> g) {
        return obj -> g.apply((Detector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectorId;
        private String description;
        private String lastUpdatedTime;
        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Detector model) {
            this.detectorId(model.detectorId);
            this.description(model.description);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdTime(model.createdTime);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public Detector build() {
            return new Detector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Detector> {
        public Builder detectorId(String var1);

        public Builder description(String var1);

        public Builder lastUpdatedTime(String var1);

        public Builder createdTime(String var1);
    }
}

