/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.LabelSchema;
import software.amazon.awssdk.services.frauddetector.model.ModelTypeEnum;
import software.amazon.awssdk.services.frauddetector.model.ModelVariable;
import software.amazon.awssdk.services.frauddetector.model.ModelVariablesListCopier;
import software.amazon.awssdk.services.frauddetector.model.TrainingDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Model
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Model> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Model.getter(Model::modelId)).setter(Model.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Model.getter(Model::modelTypeAsString)).setter(Model.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Model.getter(Model::description)).setter(Model.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TrainingDataSource> TRAINING_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Model.getter(Model::trainingDataSource)).setter(Model.setter(Builder::trainingDataSource)).constructor(TrainingDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSource").build()}).build();
    private static final SdkField<List<ModelVariable>> MODEL_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Model.getter(Model::modelVariables)).setter(Model.setter(Builder::modelVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LabelSchema> LABEL_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Model.getter(Model::labelSchema)).setter(Model.setter(Builder::labelSchema)).constructor(LabelSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelSchema").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Model.getter(Model::lastUpdatedTime)).setter(Model.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Model.getter(Model::createdTime)).setter(Model.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MODEL_TYPE_FIELD, DESCRIPTION_FIELD, TRAINING_DATA_SOURCE_FIELD, MODEL_VARIABLES_FIELD, LABEL_SCHEMA_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelId;
    private final String modelType;
    private final String description;
    private final TrainingDataSource trainingDataSource;
    private final List<ModelVariable> modelVariables;
    private final LabelSchema labelSchema;
    private final String lastUpdatedTime;
    private final String createdTime;

    private Model(BuilderImpl builder) {
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.description = builder.description;
        this.trainingDataSource = builder.trainingDataSource;
        this.modelVariables = builder.modelVariables;
        this.labelSchema = builder.labelSchema;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
    }

    public String modelId() {
        return this.modelId;
    }

    public ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(this.modelType);
    }

    public String modelTypeAsString() {
        return this.modelType;
    }

    public String description() {
        return this.description;
    }

    public TrainingDataSource trainingDataSource() {
        return this.trainingDataSource;
    }

    public boolean hasModelVariables() {
        return this.modelVariables != null && !(this.modelVariables instanceof SdkAutoConstructList);
    }

    public List<ModelVariable> modelVariables() {
        return this.modelVariables;
    }

    public LabelSchema labelSchema() {
        return this.labelSchema;
    }

    public String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Model)) {
            return false;
        }
        Model other = (Model)obj;
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.trainingDataSource(), other.trainingDataSource()) && Objects.equals(this.modelVariables(), other.modelVariables()) && Objects.equals(this.labelSchema(), other.labelSchema()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public String toString() {
        return ToString.builder((String)"Model").add("ModelId", (Object)this.modelId()).add("ModelType", (Object)this.modelTypeAsString()).add("Description", (Object)this.description()).add("TrainingDataSource", (Object)this.trainingDataSource()).add("ModelVariables", this.modelVariables()).add("LabelSchema", (Object)this.labelSchema()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "trainingDataSource": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSource()));
            }
            case "modelVariables": {
                return Optional.ofNullable(clazz.cast(this.modelVariables()));
            }
            case "labelSchema": {
                return Optional.ofNullable(clazz.cast(this.labelSchema()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Model, T> g) {
        return obj -> g.apply((Model)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelId;
        private String modelType;
        private String description;
        private TrainingDataSource trainingDataSource;
        private List<ModelVariable> modelVariables = DefaultSdkAutoConstructList.getInstance();
        private LabelSchema labelSchema;
        private String lastUpdatedTime;
        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Model model) {
            this.modelId(model.modelId);
            this.modelType(model.modelType);
            this.description(model.description);
            this.trainingDataSource(model.trainingDataSource);
            this.modelVariables(model.modelVariables);
            this.labelSchema(model.labelSchema);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdTime(model.createdTime);
        }

        public final String getModelId() {
            return this.modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getModelTypeAsString() {
            return this.modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final TrainingDataSource.Builder getTrainingDataSource() {
            return this.trainingDataSource != null ? this.trainingDataSource.toBuilder() : null;
        }

        @Override
        public final Builder trainingDataSource(TrainingDataSource trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        public final void setTrainingDataSource(TrainingDataSource.BuilderImpl trainingDataSource) {
            this.trainingDataSource = trainingDataSource != null ? trainingDataSource.build() : null;
        }

        public final Collection<ModelVariable.Builder> getModelVariables() {
            return this.modelVariables != null ? (Collection)this.modelVariables.stream().map(ModelVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modelVariables(Collection<ModelVariable> modelVariables) {
            this.modelVariables = ModelVariablesListCopier.copy(modelVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariables(ModelVariable ... modelVariables) {
            this.modelVariables(Arrays.asList(modelVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariables(Consumer<ModelVariable.Builder> ... modelVariables) {
            this.modelVariables(Stream.of(modelVariables).map(c -> (ModelVariable)((ModelVariable.Builder)ModelVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModelVariables(Collection<ModelVariable.BuilderImpl> modelVariables) {
            this.modelVariables = ModelVariablesListCopier.copyFromBuilder(modelVariables);
        }

        public final LabelSchema.Builder getLabelSchema() {
            return this.labelSchema != null ? this.labelSchema.toBuilder() : null;
        }

        @Override
        public final Builder labelSchema(LabelSchema labelSchema) {
            this.labelSchema = labelSchema;
            return this;
        }

        public final void setLabelSchema(LabelSchema.BuilderImpl labelSchema) {
            this.labelSchema = labelSchema != null ? labelSchema.build() : null;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public Model build() {
            return new Model(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Model> {
        public Builder modelId(String var1);

        public Builder modelType(String var1);

        public Builder modelType(ModelTypeEnum var1);

        public Builder description(String var1);

        public Builder trainingDataSource(TrainingDataSource var1);

        default public Builder trainingDataSource(Consumer<TrainingDataSource.Builder> trainingDataSource) {
            return this.trainingDataSource((TrainingDataSource)((TrainingDataSource.Builder)TrainingDataSource.builder().applyMutation(trainingDataSource)).build());
        }

        public Builder modelVariables(Collection<ModelVariable> var1);

        public Builder modelVariables(ModelVariable ... var1);

        public Builder modelVariables(Consumer<ModelVariable.Builder> ... var1);

        public Builder labelSchema(LabelSchema var1);

        default public Builder labelSchema(Consumer<LabelSchema.Builder> labelSchema) {
            return this.labelSchema((LabelSchema)((LabelSchema.Builder)LabelSchema.builder().applyMutation(labelSchema)).build());
        }

        public Builder lastUpdatedTime(String var1);

        public Builder createdTime(String var1);
    }
}

