/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse;

public class GetOutcomesIterable
implements SdkIterable<GetOutcomesResponse> {
    private final FraudDetectorClient client;
    private final GetOutcomesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetOutcomesIterable(FraudDetectorClient client, GetOutcomesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetOutcomesResponseFetcher();
    }

    public Iterator<GetOutcomesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetOutcomesResponseFetcher
    implements SyncPageFetcher<GetOutcomesResponse> {
        private GetOutcomesResponseFetcher() {
        }

        public boolean hasNextPage(GetOutcomesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetOutcomesResponse nextPage(GetOutcomesResponse previousPage) {
            if (previousPage == null) {
                return GetOutcomesIterable.this.client.getOutcomes(GetOutcomesIterable.this.firstRequest);
            }
            return GetOutcomesIterable.this.client.getOutcomes((GetOutcomesRequest)((Object)GetOutcomesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

