/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.DatasetGroupSummary;
import software.amazon.awssdk.services.forecast.model.DatasetGroupsCopier;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetGroupsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListDatasetGroupsResponse> {
    private static final SdkField<List<DatasetGroupSummary>> DATASET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDatasetGroupsResponse.getter(ListDatasetGroupsResponse::datasetGroups)).setter(ListDatasetGroupsResponse.setter(Builder::datasetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDatasetGroupsResponse.getter(ListDatasetGroupsResponse::nextToken)).setter(ListDatasetGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DatasetGroupSummary> datasetGroups;
    private final String nextToken;

    private ListDatasetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetGroups = builder.datasetGroups;
        this.nextToken = builder.nextToken;
    }

    public List<DatasetGroupSummary> datasetGroups() {
        return this.datasetGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetGroupsResponse)) {
            return false;
        }
        ListDatasetGroupsResponse other = (ListDatasetGroupsResponse)((Object)obj);
        return Objects.equals(this.datasetGroups(), other.datasetGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDatasetGroupsResponse").add("DatasetGroups", this.datasetGroups()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetGroups": {
                return Optional.ofNullable(clazz.cast(this.datasetGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetGroupsResponse, T> g) {
        return obj -> g.apply((ListDatasetGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<DatasetGroupSummary> datasetGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetGroupsResponse model) {
            super(model);
            this.datasetGroups(model.datasetGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<DatasetGroupSummary.Builder> getDatasetGroups() {
            return this.datasetGroups != null ? (Collection)this.datasetGroups.stream().map(DatasetGroupSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datasetGroups(Collection<DatasetGroupSummary> datasetGroups) {
            this.datasetGroups = DatasetGroupsCopier.copy(datasetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetGroups(DatasetGroupSummary ... datasetGroups) {
            this.datasetGroups(Arrays.asList(datasetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetGroups(Consumer<DatasetGroupSummary.Builder> ... datasetGroups) {
            this.datasetGroups(Stream.of(datasetGroups).map(c -> (DatasetGroupSummary)((DatasetGroupSummary.Builder)DatasetGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatasetGroups(Collection<DatasetGroupSummary.BuilderImpl> datasetGroups) {
            this.datasetGroups = DatasetGroupsCopier.copyFromBuilder(datasetGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatasetGroupsResponse build() {
            return new ListDatasetGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetGroupsResponse> {
        public Builder datasetGroups(Collection<DatasetGroupSummary> var1);

        public Builder datasetGroups(DatasetGroupSummary ... var1);

        public Builder datasetGroups(Consumer<DatasetGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

