/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.MetricResult;
import software.amazon.awssdk.services.forecast.model.MetricResultsCopier;
import software.amazon.awssdk.services.forecast.model.MonitorDataSource;
import software.amazon.awssdk.services.forecast.model.PredictorEvent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictorMonitorEvaluation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictorMonitorEvaluation> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::resourceArn)).setter(PredictorMonitorEvaluation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorArn").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::monitorArn)).setter(PredictorMonitorEvaluation.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()}).build();
    private static final SdkField<Instant> EVALUATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationTime").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::evaluationTime)).setter(PredictorMonitorEvaluation.setter(Builder::evaluationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationTime").build()}).build();
    private static final SdkField<String> EVALUATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationState").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::evaluationState)).setter(PredictorMonitorEvaluation.setter(Builder::evaluationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationState").build()}).build();
    private static final SdkField<Instant> WINDOW_START_DATETIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("WindowStartDatetime").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::windowStartDatetime)).setter(PredictorMonitorEvaluation.setter(Builder::windowStartDatetime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowStartDatetime").build()}).build();
    private static final SdkField<Instant> WINDOW_END_DATETIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("WindowEndDatetime").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::windowEndDatetime)).setter(PredictorMonitorEvaluation.setter(Builder::windowEndDatetime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowEndDatetime").build()}).build();
    private static final SdkField<PredictorEvent> PREDICTOR_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredictorEvent").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::predictorEvent)).setter(PredictorMonitorEvaluation.setter(Builder::predictorEvent)).constructor(PredictorEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorEvent").build()}).build();
    private static final SdkField<MonitorDataSource> MONITOR_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitorDataSource").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::monitorDataSource)).setter(PredictorMonitorEvaluation.setter(Builder::monitorDataSource)).constructor(MonitorDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorDataSource").build()}).build();
    private static final SdkField<List<MetricResult>> METRIC_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricResults").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::metricResults)).setter(PredictorMonitorEvaluation.setter(Builder::metricResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> NUM_ITEMS_EVALUATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumItemsEvaluated").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::numItemsEvaluated)).setter(PredictorMonitorEvaluation.setter(Builder::numItemsEvaluated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumItemsEvaluated").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(PredictorMonitorEvaluation.getter(PredictorMonitorEvaluation::message)).setter(PredictorMonitorEvaluation.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, MONITOR_ARN_FIELD, EVALUATION_TIME_FIELD, EVALUATION_STATE_FIELD, WINDOW_START_DATETIME_FIELD, WINDOW_END_DATETIME_FIELD, PREDICTOR_EVENT_FIELD, MONITOR_DATA_SOURCE_FIELD, METRIC_RESULTS_FIELD, NUM_ITEMS_EVALUATED_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PredictorMonitorEvaluation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String monitorArn;
    private final Instant evaluationTime;
    private final String evaluationState;
    private final Instant windowStartDatetime;
    private final Instant windowEndDatetime;
    private final PredictorEvent predictorEvent;
    private final MonitorDataSource monitorDataSource;
    private final List<MetricResult> metricResults;
    private final Long numItemsEvaluated;
    private final String message;

    private PredictorMonitorEvaluation(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.monitorArn = builder.monitorArn;
        this.evaluationTime = builder.evaluationTime;
        this.evaluationState = builder.evaluationState;
        this.windowStartDatetime = builder.windowStartDatetime;
        this.windowEndDatetime = builder.windowEndDatetime;
        this.predictorEvent = builder.predictorEvent;
        this.monitorDataSource = builder.monitorDataSource;
        this.metricResults = builder.metricResults;
        this.numItemsEvaluated = builder.numItemsEvaluated;
        this.message = builder.message;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final Instant evaluationTime() {
        return this.evaluationTime;
    }

    public final String evaluationState() {
        return this.evaluationState;
    }

    public final Instant windowStartDatetime() {
        return this.windowStartDatetime;
    }

    public final Instant windowEndDatetime() {
        return this.windowEndDatetime;
    }

    public final PredictorEvent predictorEvent() {
        return this.predictorEvent;
    }

    public final MonitorDataSource monitorDataSource() {
        return this.monitorDataSource;
    }

    public final boolean hasMetricResults() {
        return this.metricResults != null && !(this.metricResults instanceof SdkAutoConstructList);
    }

    public final List<MetricResult> metricResults() {
        return this.metricResults;
    }

    public final Long numItemsEvaluated() {
        return this.numItemsEvaluated;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowStartDatetime());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowEndDatetime());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricResults() ? this.metricResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numItemsEvaluated());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorMonitorEvaluation)) {
            return false;
        }
        PredictorMonitorEvaluation other = (PredictorMonitorEvaluation)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.evaluationTime(), other.evaluationTime()) && Objects.equals(this.evaluationState(), other.evaluationState()) && Objects.equals(this.windowStartDatetime(), other.windowStartDatetime()) && Objects.equals(this.windowEndDatetime(), other.windowEndDatetime()) && Objects.equals(this.predictorEvent(), other.predictorEvent()) && Objects.equals(this.monitorDataSource(), other.monitorDataSource()) && this.hasMetricResults() == other.hasMetricResults() && Objects.equals(this.metricResults(), other.metricResults()) && Objects.equals(this.numItemsEvaluated(), other.numItemsEvaluated()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"PredictorMonitorEvaluation").add("ResourceArn", (Object)this.resourceArn()).add("MonitorArn", (Object)this.monitorArn()).add("EvaluationTime", (Object)this.evaluationTime()).add("EvaluationState", (Object)this.evaluationState()).add("WindowStartDatetime", (Object)this.windowStartDatetime()).add("WindowEndDatetime", (Object)this.windowEndDatetime()).add("PredictorEvent", (Object)this.predictorEvent()).add("MonitorDataSource", (Object)this.monitorDataSource()).add("MetricResults", this.hasMetricResults() ? this.metricResults() : null).add("NumItemsEvaluated", (Object)this.numItemsEvaluated()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "MonitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "EvaluationTime": {
                return Optional.ofNullable(clazz.cast(this.evaluationTime()));
            }
            case "EvaluationState": {
                return Optional.ofNullable(clazz.cast(this.evaluationState()));
            }
            case "WindowStartDatetime": {
                return Optional.ofNullable(clazz.cast(this.windowStartDatetime()));
            }
            case "WindowEndDatetime": {
                return Optional.ofNullable(clazz.cast(this.windowEndDatetime()));
            }
            case "PredictorEvent": {
                return Optional.ofNullable(clazz.cast(this.predictorEvent()));
            }
            case "MonitorDataSource": {
                return Optional.ofNullable(clazz.cast(this.monitorDataSource()));
            }
            case "MetricResults": {
                return Optional.ofNullable(clazz.cast(this.metricResults()));
            }
            case "NumItemsEvaluated": {
                return Optional.ofNullable(clazz.cast(this.numItemsEvaluated()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("MonitorArn", MONITOR_ARN_FIELD);
        map.put("EvaluationTime", EVALUATION_TIME_FIELD);
        map.put("EvaluationState", EVALUATION_STATE_FIELD);
        map.put("WindowStartDatetime", WINDOW_START_DATETIME_FIELD);
        map.put("WindowEndDatetime", WINDOW_END_DATETIME_FIELD);
        map.put("PredictorEvent", PREDICTOR_EVENT_FIELD);
        map.put("MonitorDataSource", MONITOR_DATA_SOURCE_FIELD);
        map.put("MetricResults", METRIC_RESULTS_FIELD);
        map.put("NumItemsEvaluated", NUM_ITEMS_EVALUATED_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictorMonitorEvaluation, T> g) {
        return obj -> g.apply((PredictorMonitorEvaluation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String monitorArn;
        private Instant evaluationTime;
        private String evaluationState;
        private Instant windowStartDatetime;
        private Instant windowEndDatetime;
        private PredictorEvent predictorEvent;
        private MonitorDataSource monitorDataSource;
        private List<MetricResult> metricResults = DefaultSdkAutoConstructList.getInstance();
        private Long numItemsEvaluated;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorMonitorEvaluation model) {
            this.resourceArn(model.resourceArn);
            this.monitorArn(model.monitorArn);
            this.evaluationTime(model.evaluationTime);
            this.evaluationState(model.evaluationState);
            this.windowStartDatetime(model.windowStartDatetime);
            this.windowEndDatetime(model.windowEndDatetime);
            this.predictorEvent(model.predictorEvent);
            this.monitorDataSource(model.monitorDataSource);
            this.metricResults(model.metricResults);
            this.numItemsEvaluated(model.numItemsEvaluated);
            this.message(model.message);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final Instant getEvaluationTime() {
            return this.evaluationTime;
        }

        public final void setEvaluationTime(Instant evaluationTime) {
            this.evaluationTime = evaluationTime;
        }

        @Override
        public final Builder evaluationTime(Instant evaluationTime) {
            this.evaluationTime = evaluationTime;
            return this;
        }

        public final String getEvaluationState() {
            return this.evaluationState;
        }

        public final void setEvaluationState(String evaluationState) {
            this.evaluationState = evaluationState;
        }

        @Override
        public final Builder evaluationState(String evaluationState) {
            this.evaluationState = evaluationState;
            return this;
        }

        public final Instant getWindowStartDatetime() {
            return this.windowStartDatetime;
        }

        public final void setWindowStartDatetime(Instant windowStartDatetime) {
            this.windowStartDatetime = windowStartDatetime;
        }

        @Override
        public final Builder windowStartDatetime(Instant windowStartDatetime) {
            this.windowStartDatetime = windowStartDatetime;
            return this;
        }

        public final Instant getWindowEndDatetime() {
            return this.windowEndDatetime;
        }

        public final void setWindowEndDatetime(Instant windowEndDatetime) {
            this.windowEndDatetime = windowEndDatetime;
        }

        @Override
        public final Builder windowEndDatetime(Instant windowEndDatetime) {
            this.windowEndDatetime = windowEndDatetime;
            return this;
        }

        public final PredictorEvent.Builder getPredictorEvent() {
            return this.predictorEvent != null ? this.predictorEvent.toBuilder() : null;
        }

        public final void setPredictorEvent(PredictorEvent.BuilderImpl predictorEvent) {
            this.predictorEvent = predictorEvent != null ? predictorEvent.build() : null;
        }

        @Override
        public final Builder predictorEvent(PredictorEvent predictorEvent) {
            this.predictorEvent = predictorEvent;
            return this;
        }

        public final MonitorDataSource.Builder getMonitorDataSource() {
            return this.monitorDataSource != null ? this.monitorDataSource.toBuilder() : null;
        }

        public final void setMonitorDataSource(MonitorDataSource.BuilderImpl monitorDataSource) {
            this.monitorDataSource = monitorDataSource != null ? monitorDataSource.build() : null;
        }

        @Override
        public final Builder monitorDataSource(MonitorDataSource monitorDataSource) {
            this.monitorDataSource = monitorDataSource;
            return this;
        }

        public final List<MetricResult.Builder> getMetricResults() {
            List<MetricResult.Builder> result = MetricResultsCopier.copyToBuilder(this.metricResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricResults(Collection<MetricResult.BuilderImpl> metricResults) {
            this.metricResults = MetricResultsCopier.copyFromBuilder(metricResults);
        }

        @Override
        public final Builder metricResults(Collection<MetricResult> metricResults) {
            this.metricResults = MetricResultsCopier.copy(metricResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(MetricResult ... metricResults) {
            this.metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(Consumer<MetricResult.Builder> ... metricResults) {
            this.metricResults(Stream.of(metricResults).map(c -> (MetricResult)((MetricResult.Builder)MetricResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getNumItemsEvaluated() {
            return this.numItemsEvaluated;
        }

        public final void setNumItemsEvaluated(Long numItemsEvaluated) {
            this.numItemsEvaluated = numItemsEvaluated;
        }

        @Override
        public final Builder numItemsEvaluated(Long numItemsEvaluated) {
            this.numItemsEvaluated = numItemsEvaluated;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public PredictorMonitorEvaluation build() {
            return new PredictorMonitorEvaluation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictorMonitorEvaluation> {
        public Builder resourceArn(String var1);

        public Builder monitorArn(String var1);

        public Builder evaluationTime(Instant var1);

        public Builder evaluationState(String var1);

        public Builder windowStartDatetime(Instant var1);

        public Builder windowEndDatetime(Instant var1);

        public Builder predictorEvent(PredictorEvent var1);

        default public Builder predictorEvent(Consumer<PredictorEvent.Builder> predictorEvent) {
            return this.predictorEvent((PredictorEvent)((PredictorEvent.Builder)PredictorEvent.builder().applyMutation(predictorEvent)).build());
        }

        public Builder monitorDataSource(MonitorDataSource var1);

        default public Builder monitorDataSource(Consumer<MonitorDataSource.Builder> monitorDataSource) {
            return this.monitorDataSource((MonitorDataSource)((MonitorDataSource.Builder)MonitorDataSource.builder().applyMutation(monitorDataSource)).build());
        }

        public Builder metricResults(Collection<MetricResult> var1);

        public Builder metricResults(MetricResult ... var1);

        public Builder metricResults(Consumer<MetricResult.Builder> ... var1);

        public Builder numItemsEvaluated(Long var1);

        public Builder message(String var1);
    }
}

