/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A replacement dataset is a modified version of the baseline related time series that contains only the values that
 * you want to include in a what-if forecast. The replacement dataset must contain the forecast dimensions and item
 * identifiers in the baseline related time series as well as at least 1 changed time series. This dataset is merged
 * with the baseline related time series to create a transformed dataset that is used for the what-if forecast.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesReplacementsDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesReplacementsDataSource.Builder, TimeSeriesReplacementsDataSource> {
    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.<S3Config> builder(MarshallingType.SDK_POJO)
            .memberName("S3Config").getter(getter(TimeSeriesReplacementsDataSource::s3Config)).setter(setter(Builder::s3Config))
            .constructor(S3Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()).build();

    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.<Schema> builder(MarshallingType.SDK_POJO).memberName("Schema")
            .getter(getter(TimeSeriesReplacementsDataSource::schema)).setter(setter(Builder::schema))
            .constructor(Schema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(TimeSeriesReplacementsDataSource::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampFormat").getter(getter(TimeSeriesReplacementsDataSource::timestampFormat))
            .setter(setter(Builder::timestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIG_FIELD, SCHEMA_FIELD,
            FORMAT_FIELD, TIMESTAMP_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3Config s3Config;

    private final Schema schema;

    private final String format;

    private final String timestampFormat;

    private TimeSeriesReplacementsDataSource(BuilderImpl builder) {
        this.s3Config = builder.s3Config;
        this.schema = builder.schema;
        this.format = builder.format;
        this.timestampFormat = builder.timestampFormat;
    }

    /**
     * Returns the value of the S3Config property for this object.
     * 
     * @return The value of the S3Config property for this object.
     */
    public final S3Config s3Config() {
        return s3Config;
    }

    /**
     * Returns the value of the Schema property for this object.
     * 
     * @return The value of the Schema property for this object.
     */
    public final Schema schema() {
        return schema;
    }

    /**
     * <p>
     * The format of the replacement data, CSV or PARQUET.
     * </p>
     * 
     * @return The format of the replacement data, CSV or PARQUET.
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * The timestamp format of the replacement data.
     * </p>
     * 
     * @return The timestamp format of the replacement data.
     */
    public final String timestampFormat() {
        return timestampFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesReplacementsDataSource)) {
            return false;
        }
        TimeSeriesReplacementsDataSource other = (TimeSeriesReplacementsDataSource) obj;
        return Objects.equals(s3Config(), other.s3Config()) && Objects.equals(schema(), other.schema())
                && Objects.equals(format(), other.format()) && Objects.equals(timestampFormat(), other.timestampFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesReplacementsDataSource").add("S3Config", s3Config()).add("Schema", schema())
                .add("Format", format()).add("TimestampFormat", timestampFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Config":
            return Optional.ofNullable(clazz.cast(s3Config()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "TimestampFormat":
            return Optional.ofNullable(clazz.cast(timestampFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3Config", S3_CONFIG_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("TimestampFormat", TIMESTAMP_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesReplacementsDataSource, T> g) {
        return obj -> g.apply((TimeSeriesReplacementsDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesReplacementsDataSource> {
        /**
         * Sets the value of the S3Config property for this object.
         *
         * @param s3Config
         *        The new value for the S3Config property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Config(S3Config s3Config);

        /**
         * Sets the value of the S3Config property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Config.Builder} avoiding the need to
         * create one manually via {@link S3Config#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Config.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Config(S3Config)}.
         * 
         * @param s3Config
         *        a consumer that will call methods on {@link S3Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Config(S3Config)
         */
        default Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return s3Config(S3Config.builder().applyMutation(s3Config).build());
        }

        /**
         * Sets the value of the Schema property for this object.
         *
         * @param schema
         *        The new value for the Schema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Schema schema);

        /**
         * Sets the value of the Schema property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Schema.Builder} avoiding the need to
         * create one manually via {@link Schema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schema.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Schema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Schema)
         */
        default Builder schema(Consumer<Schema.Builder> schema) {
            return schema(Schema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * The format of the replacement data, CSV or PARQUET.
         * </p>
         * 
         * @param format
         *        The format of the replacement data, CSV or PARQUET.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The timestamp format of the replacement data.
         * </p>
         * 
         * @param timestampFormat
         *        The timestamp format of the replacement data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormat(String timestampFormat);
    }

    static final class BuilderImpl implements Builder {
        private S3Config s3Config;

        private Schema schema;

        private String format;

        private String timestampFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesReplacementsDataSource model) {
            s3Config(model.s3Config);
            schema(model.schema);
            format(model.format);
            timestampFormat(model.timestampFormat);
        }

        public final S3Config.Builder getS3Config() {
            return s3Config != null ? s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        public final Schema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getTimestampFormat() {
            return timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        @Override
        public TimeSeriesReplacementsDataSource build() {
            return new TimeSeriesReplacementsDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
