/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the monitor properties used in the <a>ListMonitors</a> operation. To get a complete set of
 * properties, call the <a>DescribeMonitor</a> operation, and provide the listed <code>MonitorArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitorSummary implements SdkPojo, Serializable, ToCopyableBuilder<MonitorSummary.Builder, MonitorSummary> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorArn").getter(getter(MonitorSummary::monitorArn)).setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()).build();

    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorName").getter(getter(MonitorSummary::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(MonitorSummary::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MonitorSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(MonitorSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(MonitorSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD,
            MONITOR_NAME_FIELD, RESOURCE_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String monitorArn;

    private final String monitorName;

    private final String resourceArn;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private MonitorSummary(BuilderImpl builder) {
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
        this.resourceArn = builder.resourceArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitor resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitor resource.
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * <p>
     * The name of the monitor resource.
     * </p>
     * 
     * @return The name of the monitor resource.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the predictor being monitored.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the predictor being monitored.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The status of the monitor. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE_STOPPING</code>, <code>ACTIVE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the monitor. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE_STOPPING</code>, <code>ACTIVE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * When the monitor resource was created.
     * </p>
     * 
     * @return When the monitor resource was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the monitor resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - When the resource stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the monitor creation finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the monitor resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> - When the resource stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the monitor creation finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorSummary)) {
            return false;
        }
        MonitorSummary other = (MonitorSummary) obj;
        return Objects.equals(monitorArn(), other.monitorArn()) && Objects.equals(monitorName(), other.monitorName())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(status(), other.status())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitorSummary").add("MonitorArn", monitorArn()).add("MonitorName", monitorName())
                .add("ResourceArn", resourceArn()).add("Status", status()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "MonitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitorArn", MONITOR_ARN_FIELD);
        map.put("MonitorName", MONITOR_NAME_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitorSummary, T> g) {
        return obj -> g.apply((MonitorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitorSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitor resource.
         * </p>
         * 
         * @param monitorArn
         *        The Amazon Resource Name (ARN) of the monitor resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * The name of the monitor resource.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the predictor being monitored.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the predictor being monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The status of the monitor. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE_STOPPING</code>, <code>ACTIVE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the monitor. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE_STOPPING</code>, <code>ACTIVE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * When the monitor resource was created.
         * </p>
         * 
         * @param creationTime
         *        When the monitor resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the monitor resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> - When the resource stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the monitor creation finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the monitor resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> - When the resource stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the monitor creation finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String monitorArn;

        private String monitorName;

        private String resourceArn;

        private String status;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorSummary model) {
            monitorArn(model.monitorArn);
            monitorName(model.monitorName);
            resourceArn(model.resourceArn);
            status(model.status);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public MonitorSummary build() {
            return new MonitorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
