/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWhatIfForecastExportsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListWhatIfForecastExportsResponse.Builder, ListWhatIfForecastExportsResponse> {
    private static final SdkField<List<WhatIfForecastExportSummary>> WHAT_IF_FORECAST_EXPORTS_FIELD = SdkField
            .<List<WhatIfForecastExportSummary>> builder(MarshallingType.LIST)
            .memberName("WhatIfForecastExports")
            .getter(getter(ListWhatIfForecastExportsResponse::whatIfForecastExports))
            .setter(setter(Builder::whatIfForecastExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastExports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WhatIfForecastExportSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WhatIfForecastExportSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWhatIfForecastExportsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WHAT_IF_FORECAST_EXPORTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<WhatIfForecastExportSummary> whatIfForecastExports;

    private final String nextToken;

    private ListWhatIfForecastExportsResponse(BuilderImpl builder) {
        super(builder);
        this.whatIfForecastExports = builder.whatIfForecastExports;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WhatIfForecastExports property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWhatIfForecastExports() {
        return whatIfForecastExports != null && !(whatIfForecastExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>WhatIfForecastExports</code> objects that describe the matched forecast exports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWhatIfForecastExports} method.
     * </p>
     * 
     * @return An array of <code>WhatIfForecastExports</code> objects that describe the matched forecast exports.
     */
    public final List<WhatIfForecastExportSummary> whatIfForecastExports() {
        return whatIfForecastExports;
    }

    /**
     * <p>
     * If the response is truncated, Forecast returns this token. To retrieve the next set of results, use the token in
     * the next request.
     * </p>
     * 
     * @return If the response is truncated, Forecast returns this token. To retrieve the next set of results, use the
     *         token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWhatIfForecastExports() ? whatIfForecastExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWhatIfForecastExportsResponse)) {
            return false;
        }
        ListWhatIfForecastExportsResponse other = (ListWhatIfForecastExportsResponse) obj;
        return hasWhatIfForecastExports() == other.hasWhatIfForecastExports()
                && Objects.equals(whatIfForecastExports(), other.whatIfForecastExports())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWhatIfForecastExportsResponse")
                .add("WhatIfForecastExports", hasWhatIfForecastExports() ? whatIfForecastExports() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfForecastExports":
            return Optional.ofNullable(clazz.cast(whatIfForecastExports()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WhatIfForecastExports", WHAT_IF_FORECAST_EXPORTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWhatIfForecastExportsResponse, T> g) {
        return obj -> g.apply((ListWhatIfForecastExportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ForecastResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWhatIfForecastExportsResponse> {
        /**
         * <p>
         * An array of <code>WhatIfForecastExports</code> objects that describe the matched forecast exports.
         * </p>
         * 
         * @param whatIfForecastExports
         *        An array of <code>WhatIfForecastExports</code> objects that describe the matched forecast exports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastExports(Collection<WhatIfForecastExportSummary> whatIfForecastExports);

        /**
         * <p>
         * An array of <code>WhatIfForecastExports</code> objects that describe the matched forecast exports.
         * </p>
         * 
         * @param whatIfForecastExports
         *        An array of <code>WhatIfForecastExports</code> objects that describe the matched forecast exports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastExports(WhatIfForecastExportSummary... whatIfForecastExports);

        /**
         * <p>
         * An array of <code>WhatIfForecastExports</code> objects that describe the matched forecast exports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #whatIfForecastExports(List<WhatIfForecastExportSummary>)}.
         * 
         * @param whatIfForecastExports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #whatIfForecastExports(java.util.Collection<WhatIfForecastExportSummary>)
         */
        Builder whatIfForecastExports(Consumer<WhatIfForecastExportSummary.Builder>... whatIfForecastExports);

        /**
         * <p>
         * If the response is truncated, Forecast returns this token. To retrieve the next set of results, use the token
         * in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Forecast returns this token. To retrieve the next set of results, use
         *        the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<WhatIfForecastExportSummary> whatIfForecastExports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWhatIfForecastExportsResponse model) {
            super(model);
            whatIfForecastExports(model.whatIfForecastExports);
            nextToken(model.nextToken);
        }

        public final List<WhatIfForecastExportSummary.Builder> getWhatIfForecastExports() {
            List<WhatIfForecastExportSummary.Builder> result = WhatIfForecastExportsCopier
                    .copyToBuilder(this.whatIfForecastExports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWhatIfForecastExports(Collection<WhatIfForecastExportSummary.BuilderImpl> whatIfForecastExports) {
            this.whatIfForecastExports = WhatIfForecastExportsCopier.copyFromBuilder(whatIfForecastExports);
        }

        @Override
        public final Builder whatIfForecastExports(Collection<WhatIfForecastExportSummary> whatIfForecastExports) {
            this.whatIfForecastExports = WhatIfForecastExportsCopier.copy(whatIfForecastExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecastExports(WhatIfForecastExportSummary... whatIfForecastExports) {
            whatIfForecastExports(Arrays.asList(whatIfForecastExports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecastExports(Consumer<WhatIfForecastExportSummary.Builder>... whatIfForecastExports) {
            whatIfForecastExports(Stream.of(whatIfForecastExports)
                    .map(c -> WhatIfForecastExportSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWhatIfForecastExportsResponse build() {
            return new ListWhatIfForecastExportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
