/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListForecastExportJobsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListForecastExportJobsResponse.Builder, ListForecastExportJobsResponse> {
    private static final SdkField<List<ForecastExportJobSummary>> FORECAST_EXPORT_JOBS_FIELD = SdkField
            .<List<ForecastExportJobSummary>> builder(MarshallingType.LIST)
            .memberName("ForecastExportJobs")
            .getter(getter(ListForecastExportJobsResponse::forecastExportJobs))
            .setter(setter(Builder::forecastExportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastExportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ForecastExportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ForecastExportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListForecastExportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_EXPORT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ForecastExportJobSummary> forecastExportJobs;

    private final String nextToken;

    private ListForecastExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.forecastExportJobs = builder.forecastExportJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastExportJobs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastExportJobs() {
        return forecastExportJobs != null && !(forecastExportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize each export job's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastExportJobs} method.
     * </p>
     * 
     * @return An array of objects that summarize each export job's properties.
     */
    public final List<ForecastExportJobSummary> forecastExportJobs() {
        return forecastExportJobs;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the
     * token in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
     *         use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastExportJobs() ? forecastExportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListForecastExportJobsResponse)) {
            return false;
        }
        ListForecastExportJobsResponse other = (ListForecastExportJobsResponse) obj;
        return hasForecastExportJobs() == other.hasForecastExportJobs()
                && Objects.equals(forecastExportJobs(), other.forecastExportJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListForecastExportJobsResponse")
                .add("ForecastExportJobs", hasForecastExportJobs() ? forecastExportJobs() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastExportJobs":
            return Optional.ofNullable(clazz.cast(forecastExportJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ForecastExportJobs", FORECAST_EXPORT_JOBS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListForecastExportJobsResponse, T> g) {
        return obj -> g.apply((ListForecastExportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListForecastExportJobsResponse> {
        /**
         * <p>
         * An array of objects that summarize each export job's properties.
         * </p>
         * 
         * @param forecastExportJobs
         *        An array of objects that summarize each export job's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastExportJobs(Collection<ForecastExportJobSummary> forecastExportJobs);

        /**
         * <p>
         * An array of objects that summarize each export job's properties.
         * </p>
         * 
         * @param forecastExportJobs
         *        An array of objects that summarize each export job's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastExportJobs(ForecastExportJobSummary... forecastExportJobs);

        /**
         * <p>
         * An array of objects that summarize each export job's properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #forecastExportJobs(List<ForecastExportJobSummary>)}.
         * 
         * @param forecastExportJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecastExportJobs(java.util.Collection<ForecastExportJobSummary>)
         */
        Builder forecastExportJobs(Consumer<ForecastExportJobSummary.Builder>... forecastExportJobs);

        /**
         * <p>
         * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use
         * the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
         *        use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<ForecastExportJobSummary> forecastExportJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListForecastExportJobsResponse model) {
            super(model);
            forecastExportJobs(model.forecastExportJobs);
            nextToken(model.nextToken);
        }

        public final List<ForecastExportJobSummary.Builder> getForecastExportJobs() {
            List<ForecastExportJobSummary.Builder> result = ForecastExportJobsCopier.copyToBuilder(this.forecastExportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForecastExportJobs(Collection<ForecastExportJobSummary.BuilderImpl> forecastExportJobs) {
            this.forecastExportJobs = ForecastExportJobsCopier.copyFromBuilder(forecastExportJobs);
        }

        @Override
        public final Builder forecastExportJobs(Collection<ForecastExportJobSummary> forecastExportJobs) {
            this.forecastExportJobs = ForecastExportJobsCopier.copy(forecastExportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastExportJobs(ForecastExportJobSummary... forecastExportJobs) {
            forecastExportJobs(Arrays.asList(forecastExportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastExportJobs(Consumer<ForecastExportJobSummary.Builder>... forecastExportJobs) {
            forecastExportJobs(Stream.of(forecastExportJobs)
                    .map(c -> ForecastExportJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListForecastExportJobsResponse build() {
            return new ListForecastExportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
