/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExplainabilitiesResponse extends ForecastResponse implements
        ToCopyableBuilder<ListExplainabilitiesResponse.Builder, ListExplainabilitiesResponse> {
    private static final SdkField<List<ExplainabilitySummary>> EXPLAINABILITIES_FIELD = SdkField
            .<List<ExplainabilitySummary>> builder(MarshallingType.LIST)
            .memberName("Explainabilities")
            .getter(getter(ListExplainabilitiesResponse::explainabilities))
            .setter(setter(Builder::explainabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explainabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExplainabilitySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExplainabilitySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListExplainabilitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ExplainabilitySummary> explainabilities;

    private final String nextToken;

    private ListExplainabilitiesResponse(BuilderImpl builder) {
        super(builder);
        this.explainabilities = builder.explainabilities;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Explainabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExplainabilities() {
        return explainabilities != null && !(explainabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize the properties of each Explainability resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExplainabilities} method.
     * </p>
     * 
     * @return An array of objects that summarize the properties of each Explainability resource.
     */
    public final List<ExplainabilitySummary> explainabilities() {
        return explainabilities;
    }

    /**
     * <p>
     * Returns this token if the response is truncated. To retrieve the next set of results, use the token in the next
     * request.
     * </p>
     * 
     * @return Returns this token if the response is truncated. To retrieve the next set of results, use the token in
     *         the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExplainabilities() ? explainabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExplainabilitiesResponse)) {
            return false;
        }
        ListExplainabilitiesResponse other = (ListExplainabilitiesResponse) obj;
        return hasExplainabilities() == other.hasExplainabilities()
                && Objects.equals(explainabilities(), other.explainabilities()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExplainabilitiesResponse")
                .add("Explainabilities", hasExplainabilities() ? explainabilities() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Explainabilities":
            return Optional.ofNullable(clazz.cast(explainabilities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Explainabilities", EXPLAINABILITIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExplainabilitiesResponse, T> g) {
        return obj -> g.apply((ListExplainabilitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListExplainabilitiesResponse> {
        /**
         * <p>
         * An array of objects that summarize the properties of each Explainability resource.
         * </p>
         * 
         * @param explainabilities
         *        An array of objects that summarize the properties of each Explainability resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilities(Collection<ExplainabilitySummary> explainabilities);

        /**
         * <p>
         * An array of objects that summarize the properties of each Explainability resource.
         * </p>
         * 
         * @param explainabilities
         *        An array of objects that summarize the properties of each Explainability resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilities(ExplainabilitySummary... explainabilities);

        /**
         * <p>
         * An array of objects that summarize the properties of each Explainability resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.ExplainabilitySummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.forecast.model.ExplainabilitySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.ExplainabilitySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #explainabilities(List<ExplainabilitySummary>)}.
         * 
         * @param explainabilities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.ExplainabilitySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explainabilities(java.util.Collection<ExplainabilitySummary>)
         */
        Builder explainabilities(Consumer<ExplainabilitySummary.Builder>... explainabilities);

        /**
         * <p>
         * Returns this token if the response is truncated. To retrieve the next set of results, use the token in the
         * next request.
         * </p>
         * 
         * @param nextToken
         *        Returns this token if the response is truncated. To retrieve the next set of results, use the token in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<ExplainabilitySummary> explainabilities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExplainabilitiesResponse model) {
            super(model);
            explainabilities(model.explainabilities);
            nextToken(model.nextToken);
        }

        public final List<ExplainabilitySummary.Builder> getExplainabilities() {
            List<ExplainabilitySummary.Builder> result = ExplainabilitiesCopier.copyToBuilder(this.explainabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExplainabilities(Collection<ExplainabilitySummary.BuilderImpl> explainabilities) {
            this.explainabilities = ExplainabilitiesCopier.copyFromBuilder(explainabilities);
        }

        @Override
        public final Builder explainabilities(Collection<ExplainabilitySummary> explainabilities) {
            this.explainabilities = ExplainabilitiesCopier.copy(explainabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explainabilities(ExplainabilitySummary... explainabilities) {
            explainabilities(Arrays.asList(explainabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explainabilities(Consumer<ExplainabilitySummary.Builder>... explainabilities) {
            explainabilities(Stream.of(explainabilities).map(c -> ExplainabilitySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExplainabilitiesResponse build() {
            return new ListExplainabilitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
