/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePredictorResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribePredictorResponse.Builder, DescribePredictorResponse> {
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorArn").getter(getter(DescribePredictorResponse::predictorArn))
            .setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final SdkField<String> PREDICTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorName").getter(getter(DescribePredictorResponse::predictorName))
            .setter(setter(Builder::predictorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorName").build()).build();

    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmArn").getter(getter(DescribePredictorResponse::algorithmArn))
            .setter(setter(Builder::algorithmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()).build();

    private static final SdkField<List<String>> AUTO_ML_ALGORITHM_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AutoMLAlgorithmArns")
            .getter(getter(DescribePredictorResponse::autoMLAlgorithmArns))
            .setter(setter(Builder::autoMLAlgorithmArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLAlgorithmArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> FORECAST_HORIZON_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ForecastHorizon").getter(getter(DescribePredictorResponse::forecastHorizon))
            .setter(setter(Builder::forecastHorizon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastHorizon").build()).build();

    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ForecastTypes")
            .getter(getter(DescribePredictorResponse::forecastTypes))
            .setter(setter(Builder::forecastTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PERFORM_AUTO_ML_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PerformAutoML").getter(getter(DescribePredictorResponse::performAutoML))
            .setter(setter(Builder::performAutoML))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformAutoML").build()).build();

    private static final SdkField<String> AUTO_ML_OVERRIDE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLOverrideStrategy").getter(getter(DescribePredictorResponse::autoMLOverrideStrategyAsString))
            .setter(setter(Builder::autoMLOverrideStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLOverrideStrategy").build())
            .build();

    private static final SdkField<Boolean> PERFORM_HPO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PerformHPO").getter(getter(DescribePredictorResponse::performHPO)).setter(setter(Builder::performHPO))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformHPO").build()).build();

    private static final SdkField<Map<String, String>> TRAINING_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TrainingParameters")
            .getter(getter(DescribePredictorResponse::trainingParameters))
            .setter(setter(Builder::trainingParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<EvaluationParameters> EVALUATION_PARAMETERS_FIELD = SdkField
            .<EvaluationParameters> builder(MarshallingType.SDK_POJO).memberName("EvaluationParameters")
            .getter(getter(DescribePredictorResponse::evaluationParameters)).setter(setter(Builder::evaluationParameters))
            .constructor(EvaluationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationParameters").build())
            .build();

    private static final SdkField<HyperParameterTuningJobConfig> HPO_CONFIG_FIELD = SdkField
            .<HyperParameterTuningJobConfig> builder(MarshallingType.SDK_POJO).memberName("HPOConfig")
            .getter(getter(DescribePredictorResponse::hpoConfig)).setter(setter(Builder::hpoConfig))
            .constructor(HyperParameterTuningJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HPOConfig").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(DescribePredictorResponse::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<FeaturizationConfig> FEATURIZATION_CONFIG_FIELD = SdkField
            .<FeaturizationConfig> builder(MarshallingType.SDK_POJO).memberName("FeaturizationConfig")
            .getter(getter(DescribePredictorResponse::featurizationConfig)).setter(setter(Builder::featurizationConfig))
            .constructor(FeaturizationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturizationConfig").build())
            .build();

    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField
            .<EncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfig")
            .getter(getter(DescribePredictorResponse::encryptionConfig)).setter(setter(Builder::encryptionConfig))
            .constructor(EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()).build();

    private static final SdkField<PredictorExecutionDetails> PREDICTOR_EXECUTION_DETAILS_FIELD = SdkField
            .<PredictorExecutionDetails> builder(MarshallingType.SDK_POJO).memberName("PredictorExecutionDetails")
            .getter(getter(DescribePredictorResponse::predictorExecutionDetails))
            .setter(setter(Builder::predictorExecutionDetails)).constructor(PredictorExecutionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorExecutionDetails").build())
            .build();

    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeRemainingInMinutes")
            .getter(getter(DescribePredictorResponse::estimatedTimeRemainingInMinutes))
            .setter(setter(Builder::estimatedTimeRemainingInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes")
                    .build()).build();

    private static final SdkField<Boolean> IS_AUTO_PREDICTOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsAutoPredictor").getter(getter(DescribePredictorResponse::isAutoPredictor))
            .setter(setter(Builder::isAutoPredictor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAutoPredictor").build()).build();

    private static final SdkField<List<String>> DATASET_IMPORT_JOB_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DatasetImportJobArns")
            .getter(getter(DescribePredictorResponse::datasetImportJobArns))
            .setter(setter(Builder::datasetImportJobArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribePredictorResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribePredictorResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribePredictorResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribePredictorResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<String> OPTIMIZATION_METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationMetric").getter(getter(DescribePredictorResponse::optimizationMetricAsString))
            .setter(setter(Builder::optimizationMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationMetric").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_ARN_FIELD,
            PREDICTOR_NAME_FIELD, ALGORITHM_ARN_FIELD, AUTO_ML_ALGORITHM_ARNS_FIELD, FORECAST_HORIZON_FIELD,
            FORECAST_TYPES_FIELD, PERFORM_AUTO_ML_FIELD, AUTO_ML_OVERRIDE_STRATEGY_FIELD, PERFORM_HPO_FIELD,
            TRAINING_PARAMETERS_FIELD, EVALUATION_PARAMETERS_FIELD, HPO_CONFIG_FIELD, INPUT_DATA_CONFIG_FIELD,
            FEATURIZATION_CONFIG_FIELD, ENCRYPTION_CONFIG_FIELD, PREDICTOR_EXECUTION_DETAILS_FIELD,
            ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, IS_AUTO_PREDICTOR_FIELD, DATASET_IMPORT_JOB_ARNS_FIELD, STATUS_FIELD,
            MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, OPTIMIZATION_METRIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String predictorArn;

    private final String predictorName;

    private final String algorithmArn;

    private final List<String> autoMLAlgorithmArns;

    private final Integer forecastHorizon;

    private final List<String> forecastTypes;

    private final Boolean performAutoML;

    private final String autoMLOverrideStrategy;

    private final Boolean performHPO;

    private final Map<String, String> trainingParameters;

    private final EvaluationParameters evaluationParameters;

    private final HyperParameterTuningJobConfig hpoConfig;

    private final InputDataConfig inputDataConfig;

    private final FeaturizationConfig featurizationConfig;

    private final EncryptionConfig encryptionConfig;

    private final PredictorExecutionDetails predictorExecutionDetails;

    private final Long estimatedTimeRemainingInMinutes;

    private final Boolean isAutoPredictor;

    private final List<String> datasetImportJobArns;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final String optimizationMetric;

    private DescribePredictorResponse(BuilderImpl builder) {
        super(builder);
        this.predictorArn = builder.predictorArn;
        this.predictorName = builder.predictorName;
        this.algorithmArn = builder.algorithmArn;
        this.autoMLAlgorithmArns = builder.autoMLAlgorithmArns;
        this.forecastHorizon = builder.forecastHorizon;
        this.forecastTypes = builder.forecastTypes;
        this.performAutoML = builder.performAutoML;
        this.autoMLOverrideStrategy = builder.autoMLOverrideStrategy;
        this.performHPO = builder.performHPO;
        this.trainingParameters = builder.trainingParameters;
        this.evaluationParameters = builder.evaluationParameters;
        this.hpoConfig = builder.hpoConfig;
        this.inputDataConfig = builder.inputDataConfig;
        this.featurizationConfig = builder.featurizationConfig;
        this.encryptionConfig = builder.encryptionConfig;
        this.predictorExecutionDetails = builder.predictorExecutionDetails;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.isAutoPredictor = builder.isAutoPredictor;
        this.datasetImportJobArns = builder.datasetImportJobArns;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.optimizationMetric = builder.optimizationMetric;
    }

    /**
     * <p>
     * The ARN of the predictor.
     * </p>
     * 
     * @return The ARN of the predictor.
     */
    public final String predictorArn() {
        return predictorArn;
    }

    /**
     * <p>
     * The name of the predictor.
     * </p>
     * 
     * @return The name of the predictor.
     */
    public final String predictorName() {
        return predictorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the algorithm used for model training.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the algorithm used for model training.
     */
    public final String algorithmArn() {
        return algorithmArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoMLAlgorithmArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAutoMLAlgorithmArns() {
        return autoMLAlgorithmArns != null && !(autoMLAlgorithmArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoMLAlgorithmArns} method.
     * </p>
     * 
     * @return When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.
     */
    public final List<String> autoMLAlgorithmArns() {
        return autoMLAlgorithmArns;
    }

    /**
     * <p>
     * The number of time-steps of the forecast. The forecast horizon is also called the prediction length.
     * </p>
     * 
     * @return The number of time-steps of the forecast. The forecast horizon is also called the prediction length.
     */
    public final Integer forecastHorizon() {
        return forecastHorizon;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastTypes() {
        return forecastTypes != null && !(forecastTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastTypes} method.
     * </p>
     * 
     * @return The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
     */
    public final List<String> forecastTypes() {
        return forecastTypes;
    }

    /**
     * <p>
     * Whether the predictor is set to perform AutoML.
     * </p>
     * 
     * @return Whether the predictor is set to perform AutoML.
     */
    public final Boolean performAutoML() {
        return performAutoML;
    }

    /**
     * <note>
     * <p>
     * The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact Amazon Web
     * Services Support or your account manager to learn more about access privileges.
     * </p>
     * </note>
     * <p>
     * The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the AutoML
     * strategy optimizes predictor accuracy.
     * </p>
     * <p>
     * This parameter is only valid for predictors trained using AutoML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLOverrideStrategy} will return {@link AutoMLOverrideStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoMLOverrideStrategyAsString}.
     * </p>
     * 
     * @return <p>
     *         The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact
     *         Amazon Web Services Support or your account manager to learn more about access privileges.
     *         </p>
     *         </note>
     *         <p>
     *         The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the
     *         AutoML strategy optimizes predictor accuracy.
     *         </p>
     *         <p>
     *         This parameter is only valid for predictors trained using AutoML.
     * @see AutoMLOverrideStrategy
     */
    public final AutoMLOverrideStrategy autoMLOverrideStrategy() {
        return AutoMLOverrideStrategy.fromValue(autoMLOverrideStrategy);
    }

    /**
     * <note>
     * <p>
     * The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact Amazon Web
     * Services Support or your account manager to learn more about access privileges.
     * </p>
     * </note>
     * <p>
     * The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the AutoML
     * strategy optimizes predictor accuracy.
     * </p>
     * <p>
     * This parameter is only valid for predictors trained using AutoML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLOverrideStrategy} will return {@link AutoMLOverrideStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoMLOverrideStrategyAsString}.
     * </p>
     * 
     * @return <p>
     *         The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact
     *         Amazon Web Services Support or your account manager to learn more about access privileges.
     *         </p>
     *         </note>
     *         <p>
     *         The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the
     *         AutoML strategy optimizes predictor accuracy.
     *         </p>
     *         <p>
     *         This parameter is only valid for predictors trained using AutoML.
     * @see AutoMLOverrideStrategy
     */
    public final String autoMLOverrideStrategyAsString() {
        return autoMLOverrideStrategy;
    }

    /**
     * <p>
     * Whether the predictor is set to perform hyperparameter optimization (HPO).
     * </p>
     * 
     * @return Whether the predictor is set to perform hyperparameter optimization (HPO).
     */
    public final Boolean performHPO() {
        return performHPO;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrainingParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrainingParameters() {
        return trainingParameters != null && !(trainingParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The default training parameters or overrides selected during model training. When running AutoML or choosing HPO
     * with CNN-QR or DeepAR+, the optimized values for the chosen hyperparameters are returned. For more information,
     * see <a>aws-forecast-choosing-recipes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrainingParameters} method.
     * </p>
     * 
     * @return The default training parameters or overrides selected during model training. When running AutoML or
     *         choosing HPO with CNN-QR or DeepAR+, the optimized values for the chosen hyperparameters are returned.
     *         For more information, see <a>aws-forecast-choosing-recipes</a>.
     */
    public final Map<String, String> trainingParameters() {
        return trainingParameters;
    }

    /**
     * <p>
     * Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates a
     * predictor by splitting a dataset into training data and testing data. The evaluation parameters define how to
     * perform the split and the number of iterations.
     * </p>
     * 
     * @return Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates
     *         a predictor by splitting a dataset into training data and testing data. The evaluation parameters define
     *         how to perform the split and the number of iterations.
     */
    public final EvaluationParameters evaluationParameters() {
        return evaluationParameters;
    }

    /**
     * <p>
     * The hyperparameter override values for the algorithm.
     * </p>
     * 
     * @return The hyperparameter override values for the algorithm.
     */
    public final HyperParameterTuningJobConfig hpoConfig() {
        return hpoConfig;
    }

    /**
     * <p>
     * Describes the dataset group that contains the data to use to train the predictor.
     * </p>
     * 
     * @return Describes the dataset group that contains the data to use to train the predictor.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * The featurization configuration.
     * </p>
     * 
     * @return The featurization configuration.
     */
    public final FeaturizationConfig featurizationConfig() {
        return featurizationConfig;
    }

    /**
     * <p>
     * An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can
     * assume to access the key.
     * </p>
     * 
     * @return An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon
     *         Forecast can assume to access the key.
     */
    public final EncryptionConfig encryptionConfig() {
        return encryptionConfig;
    }

    /**
     * <p>
     * Details on the the status and results of the backtests performed to evaluate the accuracy of the predictor. You
     * specify the number of backtests to perform when you call the operation.
     * </p>
     * 
     * @return Details on the the status and results of the backtests performed to evaluate the accuracy of the
     *         predictor. You specify the number of backtests to perform when you call the operation.
     */
    public final PredictorExecutionDetails predictorExecutionDetails() {
        return predictorExecutionDetails;
    }

    /**
     * <p>
     * The estimated time remaining in minutes for the predictor training job to complete.
     * </p>
     * 
     * @return The estimated time remaining in minutes for the predictor training job to complete.
     */
    public final Long estimatedTimeRemainingInMinutes() {
        return estimatedTimeRemainingInMinutes;
    }

    /**
     * <p>
     * Whether the predictor was created with <a>CreateAutoPredictor</a>.
     * </p>
     * 
     * @return Whether the predictor was created with <a>CreateAutoPredictor</a>.
     */
    public final Boolean isAutoPredictor() {
        return isAutoPredictor;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasetImportJobArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasetImportJobArns() {
        return datasetImportJobArns != null && !(datasetImportJobArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the ARNs of the dataset import jobs used to import training data for the predictor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasetImportJobArns} method.
     * </p>
     * 
     * @return An array of the ARNs of the dataset import jobs used to import training data for the predictor.
     */
    public final List<String> datasetImportJobArns() {
        return datasetImportJobArns;
    }

    /**
     * <p>
     * The status of the predictor. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to create a
     * forecast.
     * </p>
     * </note>
     * 
     * @return The status of the predictor. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to
     *         create a forecast.
     *         </p>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the model training task was created.
     * </p>
     * 
     * @return When the model training task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The accuracy metric used to optimize the predictor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationMetric} will return {@link OptimizationMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizationMetricAsString}.
     * </p>
     * 
     * @return The accuracy metric used to optimize the predictor.
     * @see OptimizationMetric
     */
    public final OptimizationMetric optimizationMetric() {
        return OptimizationMetric.fromValue(optimizationMetric);
    }

    /**
     * <p>
     * The accuracy metric used to optimize the predictor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationMetric} will return {@link OptimizationMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizationMetricAsString}.
     * </p>
     * 
     * @return The accuracy metric used to optimize the predictor.
     * @see OptimizationMetric
     */
    public final String optimizationMetricAsString() {
        return optimizationMetric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(predictorName());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoMLAlgorithmArns() ? autoMLAlgorithmArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(forecastHorizon());
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastTypes() ? forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(performAutoML());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLOverrideStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(performHPO());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainingParameters() ? trainingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(hpoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(featurizationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(predictorExecutionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(isAutoPredictor());
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasetImportJobArns() ? datasetImportJobArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationMetricAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePredictorResponse)) {
            return false;
        }
        DescribePredictorResponse other = (DescribePredictorResponse) obj;
        return Objects.equals(predictorArn(), other.predictorArn()) && Objects.equals(predictorName(), other.predictorName())
                && Objects.equals(algorithmArn(), other.algorithmArn())
                && hasAutoMLAlgorithmArns() == other.hasAutoMLAlgorithmArns()
                && Objects.equals(autoMLAlgorithmArns(), other.autoMLAlgorithmArns())
                && Objects.equals(forecastHorizon(), other.forecastHorizon()) && hasForecastTypes() == other.hasForecastTypes()
                && Objects.equals(forecastTypes(), other.forecastTypes())
                && Objects.equals(performAutoML(), other.performAutoML())
                && Objects.equals(autoMLOverrideStrategyAsString(), other.autoMLOverrideStrategyAsString())
                && Objects.equals(performHPO(), other.performHPO()) && hasTrainingParameters() == other.hasTrainingParameters()
                && Objects.equals(trainingParameters(), other.trainingParameters())
                && Objects.equals(evaluationParameters(), other.evaluationParameters())
                && Objects.equals(hpoConfig(), other.hpoConfig()) && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(featurizationConfig(), other.featurizationConfig())
                && Objects.equals(encryptionConfig(), other.encryptionConfig())
                && Objects.equals(predictorExecutionDetails(), other.predictorExecutionDetails())
                && Objects.equals(estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes())
                && Objects.equals(isAutoPredictor(), other.isAutoPredictor())
                && hasDatasetImportJobArns() == other.hasDatasetImportJobArns()
                && Objects.equals(datasetImportJobArns(), other.datasetImportJobArns())
                && Objects.equals(status(), other.status()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(optimizationMetricAsString(), other.optimizationMetricAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePredictorResponse").add("PredictorArn", predictorArn())
                .add("PredictorName", predictorName()).add("AlgorithmArn", algorithmArn())
                .add("AutoMLAlgorithmArns", hasAutoMLAlgorithmArns() ? autoMLAlgorithmArns() : null)
                .add("ForecastHorizon", forecastHorizon()).add("ForecastTypes", hasForecastTypes() ? forecastTypes() : null)
                .add("PerformAutoML", performAutoML()).add("AutoMLOverrideStrategy", autoMLOverrideStrategyAsString())
                .add("PerformHPO", performHPO()).add("TrainingParameters", hasTrainingParameters() ? trainingParameters() : null)
                .add("EvaluationParameters", evaluationParameters()).add("HPOConfig", hpoConfig())
                .add("InputDataConfig", inputDataConfig()).add("FeaturizationConfig", featurizationConfig())
                .add("EncryptionConfig", encryptionConfig()).add("PredictorExecutionDetails", predictorExecutionDetails())
                .add("EstimatedTimeRemainingInMinutes", estimatedTimeRemainingInMinutes())
                .add("IsAutoPredictor", isAutoPredictor())
                .add("DatasetImportJobArns", hasDatasetImportJobArns() ? datasetImportJobArns() : null).add("Status", status())
                .add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).add("OptimizationMetric", optimizationMetricAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        case "PredictorName":
            return Optional.ofNullable(clazz.cast(predictorName()));
        case "AlgorithmArn":
            return Optional.ofNullable(clazz.cast(algorithmArn()));
        case "AutoMLAlgorithmArns":
            return Optional.ofNullable(clazz.cast(autoMLAlgorithmArns()));
        case "ForecastHorizon":
            return Optional.ofNullable(clazz.cast(forecastHorizon()));
        case "ForecastTypes":
            return Optional.ofNullable(clazz.cast(forecastTypes()));
        case "PerformAutoML":
            return Optional.ofNullable(clazz.cast(performAutoML()));
        case "AutoMLOverrideStrategy":
            return Optional.ofNullable(clazz.cast(autoMLOverrideStrategyAsString()));
        case "PerformHPO":
            return Optional.ofNullable(clazz.cast(performHPO()));
        case "TrainingParameters":
            return Optional.ofNullable(clazz.cast(trainingParameters()));
        case "EvaluationParameters":
            return Optional.ofNullable(clazz.cast(evaluationParameters()));
        case "HPOConfig":
            return Optional.ofNullable(clazz.cast(hpoConfig()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "FeaturizationConfig":
            return Optional.ofNullable(clazz.cast(featurizationConfig()));
        case "EncryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        case "PredictorExecutionDetails":
            return Optional.ofNullable(clazz.cast(predictorExecutionDetails()));
        case "EstimatedTimeRemainingInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedTimeRemainingInMinutes()));
        case "IsAutoPredictor":
            return Optional.ofNullable(clazz.cast(isAutoPredictor()));
        case "DatasetImportJobArns":
            return Optional.ofNullable(clazz.cast(datasetImportJobArns()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "OptimizationMetric":
            return Optional.ofNullable(clazz.cast(optimizationMetricAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PredictorArn", PREDICTOR_ARN_FIELD);
        map.put("PredictorName", PREDICTOR_NAME_FIELD);
        map.put("AlgorithmArn", ALGORITHM_ARN_FIELD);
        map.put("AutoMLAlgorithmArns", AUTO_ML_ALGORITHM_ARNS_FIELD);
        map.put("ForecastHorizon", FORECAST_HORIZON_FIELD);
        map.put("ForecastTypes", FORECAST_TYPES_FIELD);
        map.put("PerformAutoML", PERFORM_AUTO_ML_FIELD);
        map.put("AutoMLOverrideStrategy", AUTO_ML_OVERRIDE_STRATEGY_FIELD);
        map.put("PerformHPO", PERFORM_HPO_FIELD);
        map.put("TrainingParameters", TRAINING_PARAMETERS_FIELD);
        map.put("EvaluationParameters", EVALUATION_PARAMETERS_FIELD);
        map.put("HPOConfig", HPO_CONFIG_FIELD);
        map.put("InputDataConfig", INPUT_DATA_CONFIG_FIELD);
        map.put("FeaturizationConfig", FEATURIZATION_CONFIG_FIELD);
        map.put("EncryptionConfig", ENCRYPTION_CONFIG_FIELD);
        map.put("PredictorExecutionDetails", PREDICTOR_EXECUTION_DETAILS_FIELD);
        map.put("EstimatedTimeRemainingInMinutes", ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD);
        map.put("IsAutoPredictor", IS_AUTO_PREDICTOR_FIELD);
        map.put("DatasetImportJobArns", DATASET_IMPORT_JOB_ARNS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("OptimizationMetric", OPTIMIZATION_METRIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePredictorResponse, T> g) {
        return obj -> g.apply((DescribePredictorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePredictorResponse> {
        /**
         * <p>
         * The ARN of the predictor.
         * </p>
         * 
         * @param predictorArn
         *        The ARN of the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);

        /**
         * <p>
         * The name of the predictor.
         * </p>
         * 
         * @param predictorName
         *        The name of the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorName(String predictorName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the algorithm used for model training.
         * </p>
         * 
         * @param algorithmArn
         *        The Amazon Resource Name (ARN) of the algorithm used for model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmArn(String algorithmArn);

        /**
         * <p>
         * When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.
         * </p>
         * 
         * @param autoMLAlgorithmArns
         *        When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLAlgorithmArns(Collection<String> autoMLAlgorithmArns);

        /**
         * <p>
         * When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.
         * </p>
         * 
         * @param autoMLAlgorithmArns
         *        When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLAlgorithmArns(String... autoMLAlgorithmArns);

        /**
         * <p>
         * The number of time-steps of the forecast. The forecast horizon is also called the prediction length.
         * </p>
         * 
         * @param forecastHorizon
         *        The number of time-steps of the forecast. The forecast horizon is also called the prediction length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastHorizon(Integer forecastHorizon);

        /**
         * <p>
         * The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
         * </p>
         * 
         * @param forecastTypes
         *        The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(Collection<String> forecastTypes);

        /**
         * <p>
         * The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
         * </p>
         * 
         * @param forecastTypes
         *        The forecast types used during predictor training. Default value is <code>["0.1","0.5","0.9"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(String... forecastTypes);

        /**
         * <p>
         * Whether the predictor is set to perform AutoML.
         * </p>
         * 
         * @param performAutoML
         *        Whether the predictor is set to perform AutoML.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performAutoML(Boolean performAutoML);

        /**
         * <note>
         * <p>
         * The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact Amazon
         * Web Services Support or your account manager to learn more about access privileges.
         * </p>
         * </note>
         * <p>
         * The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the
         * AutoML strategy optimizes predictor accuracy.
         * </p>
         * <p>
         * This parameter is only valid for predictors trained using AutoML.
         * </p>
         * 
         * @param autoMLOverrideStrategy
         *        <p>
         *        The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact
         *        Amazon Web Services Support or your account manager to learn more about access privileges.
         *        </p>
         *        </note>
         *        <p>
         *        The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified,
         *        the AutoML strategy optimizes predictor accuracy.
         *        </p>
         *        <p>
         *        This parameter is only valid for predictors trained using AutoML.
         * @see AutoMLOverrideStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLOverrideStrategy
         */
        Builder autoMLOverrideStrategy(String autoMLOverrideStrategy);

        /**
         * <note>
         * <p>
         * The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact Amazon
         * Web Services Support or your account manager to learn more about access privileges.
         * </p>
         * </note>
         * <p>
         * The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified, the
         * AutoML strategy optimizes predictor accuracy.
         * </p>
         * <p>
         * This parameter is only valid for predictors trained using AutoML.
         * </p>
         * 
         * @param autoMLOverrideStrategy
         *        <p>
         *        The <code>LatencyOptimized</code> AutoML override strategy is only available in private beta. Contact
         *        Amazon Web Services Support or your account manager to learn more about access privileges.
         *        </p>
         *        </note>
         *        <p>
         *        The AutoML strategy used to train the predictor. Unless <code>LatencyOptimized</code> is specified,
         *        the AutoML strategy optimizes predictor accuracy.
         *        </p>
         *        <p>
         *        This parameter is only valid for predictors trained using AutoML.
         * @see AutoMLOverrideStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLOverrideStrategy
         */
        Builder autoMLOverrideStrategy(AutoMLOverrideStrategy autoMLOverrideStrategy);

        /**
         * <p>
         * Whether the predictor is set to perform hyperparameter optimization (HPO).
         * </p>
         * 
         * @param performHPO
         *        Whether the predictor is set to perform hyperparameter optimization (HPO).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performHPO(Boolean performHPO);

        /**
         * <p>
         * The default training parameters or overrides selected during model training. When running AutoML or choosing
         * HPO with CNN-QR or DeepAR+, the optimized values for the chosen hyperparameters are returned. For more
         * information, see <a>aws-forecast-choosing-recipes</a>.
         * </p>
         * 
         * @param trainingParameters
         *        The default training parameters or overrides selected during model training. When running AutoML or
         *        choosing HPO with CNN-QR or DeepAR+, the optimized values for the chosen hyperparameters are returned.
         *        For more information, see <a>aws-forecast-choosing-recipes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingParameters(Map<String, String> trainingParameters);

        /**
         * <p>
         * Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates a
         * predictor by splitting a dataset into training data and testing data. The evaluation parameters define how to
         * perform the split and the number of iterations.
         * </p>
         * 
         * @param evaluationParameters
         *        Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast
         *        evaluates a predictor by splitting a dataset into training data and testing data. The evaluation
         *        parameters define how to perform the split and the number of iterations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationParameters(EvaluationParameters evaluationParameters);

        /**
         * <p>
         * Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates a
         * predictor by splitting a dataset into training data and testing data. The evaluation parameters define how to
         * perform the split and the number of iterations.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationParameters.Builder} avoiding
         * the need to create one manually via {@link EvaluationParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #evaluationParameters(EvaluationParameters)}.
         * 
         * @param evaluationParameters
         *        a consumer that will call methods on {@link EvaluationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationParameters(EvaluationParameters)
         */
        default Builder evaluationParameters(Consumer<EvaluationParameters.Builder> evaluationParameters) {
            return evaluationParameters(EvaluationParameters.builder().applyMutation(evaluationParameters).build());
        }

        /**
         * <p>
         * The hyperparameter override values for the algorithm.
         * </p>
         * 
         * @param hpoConfig
         *        The hyperparameter override values for the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hpoConfig(HyperParameterTuningJobConfig hpoConfig);

        /**
         * <p>
         * The hyperparameter override values for the algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link HyperParameterTuningJobConfig.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTuningJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #hpoConfig(HyperParameterTuningJobConfig)}.
         * 
         * @param hpoConfig
         *        a consumer that will call methods on {@link HyperParameterTuningJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hpoConfig(HyperParameterTuningJobConfig)
         */
        default Builder hpoConfig(Consumer<HyperParameterTuningJobConfig.Builder> hpoConfig) {
            return hpoConfig(HyperParameterTuningJobConfig.builder().applyMutation(hpoConfig).build());
        }

        /**
         * <p>
         * Describes the dataset group that contains the data to use to train the predictor.
         * </p>
         * 
         * @param inputDataConfig
         *        Describes the dataset group that contains the data to use to train the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * Describes the dataset group that contains the data to use to train the predictor.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputDataConfig.Builder} avoiding the
         * need to create one manually via {@link InputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * The featurization configuration.
         * </p>
         * 
         * @param featurizationConfig
         *        The featurization configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featurizationConfig(FeaturizationConfig featurizationConfig);

        /**
         * <p>
         * The featurization configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link FeaturizationConfig.Builder} avoiding the
         * need to create one manually via {@link FeaturizationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FeaturizationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #featurizationConfig(FeaturizationConfig)}.
         * 
         * @param featurizationConfig
         *        a consumer that will call methods on {@link FeaturizationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featurizationConfig(FeaturizationConfig)
         */
        default Builder featurizationConfig(Consumer<FeaturizationConfig.Builder> featurizationConfig) {
            return featurizationConfig(FeaturizationConfig.builder().applyMutation(featurizationConfig).build());
        }

        /**
         * <p>
         * An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast
         * can assume to access the key.
         * </p>
         * 
         * @param encryptionConfig
         *        An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon
         *        Forecast can assume to access the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig encryptionConfig);

        /**
         * <p>
         * An Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast
         * can assume to access the key.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfig.Builder} avoiding the
         * need to create one manually via {@link EncryptionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionConfig(EncryptionConfig)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(EncryptionConfig)
         */
        default Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return encryptionConfig(EncryptionConfig.builder().applyMutation(encryptionConfig).build());
        }

        /**
         * <p>
         * Details on the the status and results of the backtests performed to evaluate the accuracy of the predictor.
         * You specify the number of backtests to perform when you call the operation.
         * </p>
         * 
         * @param predictorExecutionDetails
         *        Details on the the status and results of the backtests performed to evaluate the accuracy of the
         *        predictor. You specify the number of backtests to perform when you call the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorExecutionDetails(PredictorExecutionDetails predictorExecutionDetails);

        /**
         * <p>
         * Details on the the status and results of the backtests performed to evaluate the accuracy of the predictor.
         * You specify the number of backtests to perform when you call the operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictorExecutionDetails.Builder}
         * avoiding the need to create one manually via {@link PredictorExecutionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictorExecutionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #predictorExecutionDetails(PredictorExecutionDetails)}.
         * 
         * @param predictorExecutionDetails
         *        a consumer that will call methods on {@link PredictorExecutionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictorExecutionDetails(PredictorExecutionDetails)
         */
        default Builder predictorExecutionDetails(Consumer<PredictorExecutionDetails.Builder> predictorExecutionDetails) {
            return predictorExecutionDetails(PredictorExecutionDetails.builder().applyMutation(predictorExecutionDetails).build());
        }

        /**
         * <p>
         * The estimated time remaining in minutes for the predictor training job to complete.
         * </p>
         * 
         * @param estimatedTimeRemainingInMinutes
         *        The estimated time remaining in minutes for the predictor training job to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes);

        /**
         * <p>
         * Whether the predictor was created with <a>CreateAutoPredictor</a>.
         * </p>
         * 
         * @param isAutoPredictor
         *        Whether the predictor was created with <a>CreateAutoPredictor</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAutoPredictor(Boolean isAutoPredictor);

        /**
         * <p>
         * An array of the ARNs of the dataset import jobs used to import training data for the predictor.
         * </p>
         * 
         * @param datasetImportJobArns
         *        An array of the ARNs of the dataset import jobs used to import training data for the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobArns(Collection<String> datasetImportJobArns);

        /**
         * <p>
         * An array of the ARNs of the dataset import jobs used to import training data for the predictor.
         * </p>
         * 
         * @param datasetImportJobArns
         *        An array of the ARNs of the dataset import jobs used to import training data for the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobArns(String... datasetImportJobArns);

        /**
         * <p>
         * The status of the predictor. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to
         * create a forecast.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the predictor. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor
         *        to create a forecast.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the model training task was created.
         * </p>
         * 
         * @param creationTime
         *        When the model training task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The accuracy metric used to optimize the predictor.
         * </p>
         * 
         * @param optimizationMetric
         *        The accuracy metric used to optimize the predictor.
         * @see OptimizationMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationMetric
         */
        Builder optimizationMetric(String optimizationMetric);

        /**
         * <p>
         * The accuracy metric used to optimize the predictor.
         * </p>
         * 
         * @param optimizationMetric
         *        The accuracy metric used to optimize the predictor.
         * @see OptimizationMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationMetric
         */
        Builder optimizationMetric(OptimizationMetric optimizationMetric);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String predictorArn;

        private String predictorName;

        private String algorithmArn;

        private List<String> autoMLAlgorithmArns = DefaultSdkAutoConstructList.getInstance();

        private Integer forecastHorizon;

        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean performAutoML;

        private String autoMLOverrideStrategy;

        private Boolean performHPO;

        private Map<String, String> trainingParameters = DefaultSdkAutoConstructMap.getInstance();

        private EvaluationParameters evaluationParameters;

        private HyperParameterTuningJobConfig hpoConfig;

        private InputDataConfig inputDataConfig;

        private FeaturizationConfig featurizationConfig;

        private EncryptionConfig encryptionConfig;

        private PredictorExecutionDetails predictorExecutionDetails;

        private Long estimatedTimeRemainingInMinutes;

        private Boolean isAutoPredictor;

        private List<String> datasetImportJobArns = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private String optimizationMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePredictorResponse model) {
            super(model);
            predictorArn(model.predictorArn);
            predictorName(model.predictorName);
            algorithmArn(model.algorithmArn);
            autoMLAlgorithmArns(model.autoMLAlgorithmArns);
            forecastHorizon(model.forecastHorizon);
            forecastTypes(model.forecastTypes);
            performAutoML(model.performAutoML);
            autoMLOverrideStrategy(model.autoMLOverrideStrategy);
            performHPO(model.performHPO);
            trainingParameters(model.trainingParameters);
            evaluationParameters(model.evaluationParameters);
            hpoConfig(model.hpoConfig);
            inputDataConfig(model.inputDataConfig);
            featurizationConfig(model.featurizationConfig);
            encryptionConfig(model.encryptionConfig);
            predictorExecutionDetails(model.predictorExecutionDetails);
            estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            isAutoPredictor(model.isAutoPredictor);
            datasetImportJobArns(model.datasetImportJobArns);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            optimizationMetric(model.optimizationMetric);
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final String getPredictorName() {
            return predictorName;
        }

        public final void setPredictorName(String predictorName) {
            this.predictorName = predictorName;
        }

        @Override
        public final Builder predictorName(String predictorName) {
            this.predictorName = predictorName;
            return this;
        }

        public final String getAlgorithmArn() {
            return algorithmArn;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final Collection<String> getAutoMLAlgorithmArns() {
            if (autoMLAlgorithmArns instanceof SdkAutoConstructList) {
                return null;
            }
            return autoMLAlgorithmArns;
        }

        public final void setAutoMLAlgorithmArns(Collection<String> autoMLAlgorithmArns) {
            this.autoMLAlgorithmArns = ArnListCopier.copy(autoMLAlgorithmArns);
        }

        @Override
        public final Builder autoMLAlgorithmArns(Collection<String> autoMLAlgorithmArns) {
            this.autoMLAlgorithmArns = ArnListCopier.copy(autoMLAlgorithmArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLAlgorithmArns(String... autoMLAlgorithmArns) {
            autoMLAlgorithmArns(Arrays.asList(autoMLAlgorithmArns));
            return this;
        }

        public final Integer getForecastHorizon() {
            return forecastHorizon;
        }

        public final void setForecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
        }

        @Override
        public final Builder forecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastTypes(String... forecastTypes) {
            forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final Boolean getPerformAutoML() {
            return performAutoML;
        }

        public final void setPerformAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
        }

        @Override
        public final Builder performAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
            return this;
        }

        public final String getAutoMLOverrideStrategy() {
            return autoMLOverrideStrategy;
        }

        public final void setAutoMLOverrideStrategy(String autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy = autoMLOverrideStrategy;
        }

        @Override
        public final Builder autoMLOverrideStrategy(String autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy = autoMLOverrideStrategy;
            return this;
        }

        @Override
        public final Builder autoMLOverrideStrategy(AutoMLOverrideStrategy autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy(autoMLOverrideStrategy == null ? null : autoMLOverrideStrategy.toString());
            return this;
        }

        public final Boolean getPerformHPO() {
            return performHPO;
        }

        public final void setPerformHPO(Boolean performHPO) {
            this.performHPO = performHPO;
        }

        @Override
        public final Builder performHPO(Boolean performHPO) {
            this.performHPO = performHPO;
            return this;
        }

        public final Map<String, String> getTrainingParameters() {
            if (trainingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return trainingParameters;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final EvaluationParameters.Builder getEvaluationParameters() {
            return evaluationParameters != null ? evaluationParameters.toBuilder() : null;
        }

        public final void setEvaluationParameters(EvaluationParameters.BuilderImpl evaluationParameters) {
            this.evaluationParameters = evaluationParameters != null ? evaluationParameters.build() : null;
        }

        @Override
        public final Builder evaluationParameters(EvaluationParameters evaluationParameters) {
            this.evaluationParameters = evaluationParameters;
            return this;
        }

        public final HyperParameterTuningJobConfig.Builder getHpoConfig() {
            return hpoConfig != null ? hpoConfig.toBuilder() : null;
        }

        public final void setHpoConfig(HyperParameterTuningJobConfig.BuilderImpl hpoConfig) {
            this.hpoConfig = hpoConfig != null ? hpoConfig.build() : null;
        }

        @Override
        public final Builder hpoConfig(HyperParameterTuningJobConfig hpoConfig) {
            this.hpoConfig = hpoConfig;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final FeaturizationConfig.Builder getFeaturizationConfig() {
            return featurizationConfig != null ? featurizationConfig.toBuilder() : null;
        }

        public final void setFeaturizationConfig(FeaturizationConfig.BuilderImpl featurizationConfig) {
            this.featurizationConfig = featurizationConfig != null ? featurizationConfig.build() : null;
        }

        @Override
        public final Builder featurizationConfig(FeaturizationConfig featurizationConfig) {
            this.featurizationConfig = featurizationConfig;
            return this;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final PredictorExecutionDetails.Builder getPredictorExecutionDetails() {
            return predictorExecutionDetails != null ? predictorExecutionDetails.toBuilder() : null;
        }

        public final void setPredictorExecutionDetails(PredictorExecutionDetails.BuilderImpl predictorExecutionDetails) {
            this.predictorExecutionDetails = predictorExecutionDetails != null ? predictorExecutionDetails.build() : null;
        }

        @Override
        public final Builder predictorExecutionDetails(PredictorExecutionDetails predictorExecutionDetails) {
            this.predictorExecutionDetails = predictorExecutionDetails;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final Boolean getIsAutoPredictor() {
            return isAutoPredictor;
        }

        public final void setIsAutoPredictor(Boolean isAutoPredictor) {
            this.isAutoPredictor = isAutoPredictor;
        }

        @Override
        public final Builder isAutoPredictor(Boolean isAutoPredictor) {
            this.isAutoPredictor = isAutoPredictor;
            return this;
        }

        public final Collection<String> getDatasetImportJobArns() {
            if (datasetImportJobArns instanceof SdkAutoConstructList) {
                return null;
            }
            return datasetImportJobArns;
        }

        public final void setDatasetImportJobArns(Collection<String> datasetImportJobArns) {
            this.datasetImportJobArns = ArnListCopier.copy(datasetImportJobArns);
        }

        @Override
        public final Builder datasetImportJobArns(Collection<String> datasetImportJobArns) {
            this.datasetImportJobArns = ArnListCopier.copy(datasetImportJobArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetImportJobArns(String... datasetImportJobArns) {
            datasetImportJobArns(Arrays.asList(datasetImportJobArns));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getOptimizationMetric() {
            return optimizationMetric;
        }

        public final void setOptimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
        }

        @Override
        public final Builder optimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
            return this;
        }

        @Override
        public final Builder optimizationMetric(OptimizationMetric optimizationMetric) {
            this.optimizationMetric(optimizationMetric == null ? null : optimizationMetric.toString());
            return this;
        }

        @Override
        public DescribePredictorResponse build() {
            return new DescribePredictorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
