/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.EvaluationType;
import software.amazon.awssdk.services.forecast.model.Metrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WindowSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WindowSummary> {
    private static final SdkField<Instant> TEST_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TestWindowStart").getter(WindowSummary.getter(WindowSummary::testWindowStart)).setter(WindowSummary.setter(Builder::testWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindowStart").build()}).build();
    private static final SdkField<Instant> TEST_WINDOW_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TestWindowEnd").getter(WindowSummary.getter(WindowSummary::testWindowEnd)).setter(WindowSummary.setter(Builder::testWindowEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindowEnd").build()}).build();
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ItemCount").getter(WindowSummary.getter(WindowSummary::itemCount)).setter(WindowSummary.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationType").getter(WindowSummary.getter(WindowSummary::evaluationTypeAsString)).setter(WindowSummary.setter(Builder::evaluationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()}).build();
    private static final SdkField<Metrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metrics").getter(WindowSummary.getter(WindowSummary::metrics)).setter(WindowSummary.setter(Builder::metrics)).constructor(Metrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_WINDOW_START_FIELD, TEST_WINDOW_END_FIELD, ITEM_COUNT_FIELD, EVALUATION_TYPE_FIELD, METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WindowSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant testWindowStart;
    private final Instant testWindowEnd;
    private final Integer itemCount;
    private final String evaluationType;
    private final Metrics metrics;

    private WindowSummary(BuilderImpl builder) {
        this.testWindowStart = builder.testWindowStart;
        this.testWindowEnd = builder.testWindowEnd;
        this.itemCount = builder.itemCount;
        this.evaluationType = builder.evaluationType;
        this.metrics = builder.metrics;
    }

    public final Instant testWindowStart() {
        return this.testWindowStart;
    }

    public final Instant testWindowEnd() {
        return this.testWindowEnd;
    }

    public final Integer itemCount() {
        return this.itemCount;
    }

    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(this.evaluationType);
    }

    public final String evaluationTypeAsString() {
        return this.evaluationType;
    }

    public final Metrics metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.testWindowEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowSummary)) {
            return false;
        }
        WindowSummary other = (WindowSummary)obj;
        return Objects.equals(this.testWindowStart(), other.testWindowStart()) && Objects.equals(this.testWindowEnd(), other.testWindowEnd()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.evaluationTypeAsString(), other.evaluationTypeAsString()) && Objects.equals(this.metrics(), other.metrics());
    }

    public final String toString() {
        return ToString.builder((String)"WindowSummary").add("TestWindowStart", (Object)this.testWindowStart()).add("TestWindowEnd", (Object)this.testWindowEnd()).add("ItemCount", (Object)this.itemCount()).add("EvaluationType", (Object)this.evaluationTypeAsString()).add("Metrics", (Object)this.metrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TestWindowStart": {
                return Optional.ofNullable(clazz.cast(this.testWindowStart()));
            }
            case "TestWindowEnd": {
                return Optional.ofNullable(clazz.cast(this.testWindowEnd()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "EvaluationType": {
                return Optional.ofNullable(clazz.cast(this.evaluationTypeAsString()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TestWindowStart", TEST_WINDOW_START_FIELD);
        map.put("TestWindowEnd", TEST_WINDOW_END_FIELD);
        map.put("ItemCount", ITEM_COUNT_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("Metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WindowSummary, T> g) {
        return obj -> g.apply((WindowSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant testWindowStart;
        private Instant testWindowEnd;
        private Integer itemCount;
        private String evaluationType;
        private Metrics metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowSummary model) {
            this.testWindowStart(model.testWindowStart);
            this.testWindowEnd(model.testWindowEnd);
            this.itemCount(model.itemCount);
            this.evaluationType(model.evaluationType);
            this.metrics(model.metrics);
        }

        public final Instant getTestWindowStart() {
            return this.testWindowStart;
        }

        public final void setTestWindowStart(Instant testWindowStart) {
            this.testWindowStart = testWindowStart;
        }

        @Override
        public final Builder testWindowStart(Instant testWindowStart) {
            this.testWindowStart = testWindowStart;
            return this;
        }

        public final Instant getTestWindowEnd() {
            return this.testWindowEnd;
        }

        public final void setTestWindowEnd(Instant testWindowEnd) {
            this.testWindowEnd = testWindowEnd;
        }

        @Override
        public final Builder testWindowEnd(Instant testWindowEnd) {
            this.testWindowEnd = testWindowEnd;
            return this;
        }

        public final Integer getItemCount() {
            return this.itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final String getEvaluationType() {
            return this.evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final Metrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(Metrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public WindowSummary build() {
            return new WindowSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WindowSummary> {
        public Builder testWindowStart(Instant var1);

        public Builder testWindowEnd(Instant var1);

        public Builder itemCount(Integer var1);

        public Builder evaluationType(String var1);

        public Builder evaluationType(EvaluationType var1);

        public Builder metrics(Metrics var1);

        default public Builder metrics(Consumer<Metrics.Builder> metrics) {
            return this.metrics((Metrics)((Metrics.Builder)Metrics.builder().applyMutation(metrics)).build());
        }
    }
}

