/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.PredictorExecution;
import software.amazon.awssdk.services.forecast.model.PredictorExecutionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictorExecutionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictorExecutionDetails> {
    private static final SdkField<List<PredictorExecution>> PREDICTOR_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredictorExecutions").getter(PredictorExecutionDetails.getter(PredictorExecutionDetails::predictorExecutions)).setter(PredictorExecutionDetails.setter(Builder::predictorExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictorExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_EXECUTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PredictorExecutionDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PredictorExecution> predictorExecutions;

    private PredictorExecutionDetails(BuilderImpl builder) {
        this.predictorExecutions = builder.predictorExecutions;
    }

    public final boolean hasPredictorExecutions() {
        return this.predictorExecutions != null && !(this.predictorExecutions instanceof SdkAutoConstructList);
    }

    public final List<PredictorExecution> predictorExecutions() {
        return this.predictorExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredictorExecutions() ? this.predictorExecutions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorExecutionDetails)) {
            return false;
        }
        PredictorExecutionDetails other = (PredictorExecutionDetails)obj;
        return this.hasPredictorExecutions() == other.hasPredictorExecutions() && Objects.equals(this.predictorExecutions(), other.predictorExecutions());
    }

    public final String toString() {
        return ToString.builder((String)"PredictorExecutionDetails").add("PredictorExecutions", this.hasPredictorExecutions() ? this.predictorExecutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorExecutions": {
                return Optional.ofNullable(clazz.cast(this.predictorExecutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PredictorExecution>>> map = new HashMap<String, SdkField<List<PredictorExecution>>>();
        map.put("PredictorExecutions", PREDICTOR_EXECUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictorExecutionDetails, T> g) {
        return obj -> g.apply((PredictorExecutionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PredictorExecution> predictorExecutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorExecutionDetails model) {
            this.predictorExecutions(model.predictorExecutions);
        }

        public final List<PredictorExecution.Builder> getPredictorExecutions() {
            List<PredictorExecution.Builder> result = PredictorExecutionsCopier.copyToBuilder(this.predictorExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredictorExecutions(Collection<PredictorExecution.BuilderImpl> predictorExecutions) {
            this.predictorExecutions = PredictorExecutionsCopier.copyFromBuilder(predictorExecutions);
        }

        @Override
        public final Builder predictorExecutions(Collection<PredictorExecution> predictorExecutions) {
            this.predictorExecutions = PredictorExecutionsCopier.copy(predictorExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorExecutions(PredictorExecution ... predictorExecutions) {
            this.predictorExecutions(Arrays.asList(predictorExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorExecutions(Consumer<PredictorExecution.Builder> ... predictorExecutions) {
            this.predictorExecutions(Stream.of(predictorExecutions).map(c -> (PredictorExecution)((PredictorExecution.Builder)PredictorExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PredictorExecutionDetails build() {
            return new PredictorExecutionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictorExecutionDetails> {
        public Builder predictorExecutions(Collection<PredictorExecution> var1);

        public Builder predictorExecutions(PredictorExecution ... var1);

        public Builder predictorExecutions(Consumer<PredictorExecution.Builder> ... var1);
    }
}

