/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ExplainabilitySummary;
import software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest;
import software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse;

public class ListExplainabilitiesPublisher
implements SdkPublisher<ListExplainabilitiesResponse> {
    private final ForecastAsyncClient client;
    private final ListExplainabilitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExplainabilitiesPublisher(ForecastAsyncClient client, ListExplainabilitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExplainabilitiesPublisher(ForecastAsyncClient client, ListExplainabilitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExplainabilitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExplainabilitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExplainabilitySummary> explainabilities() {
        Function<ListExplainabilitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.explainabilities() != null) {
                return response.explainabilities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExplainabilitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExplainabilitiesResponseFetcher
    implements AsyncPageFetcher<ListExplainabilitiesResponse> {
        private ListExplainabilitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListExplainabilitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExplainabilitiesResponse> nextPage(ListExplainabilitiesResponse previousPage) {
            if (previousPage == null) {
                return ListExplainabilitiesPublisher.this.client.listExplainabilities(ListExplainabilitiesPublisher.this.firstRequest);
            }
            return ListExplainabilitiesPublisher.this.client.listExplainabilities((ListExplainabilitiesRequest)((Object)ListExplainabilitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

